/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.setup;

import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.URL;

public class ConnectionSettings {
    private String url;
    private int timeout = 20;
    private TimeUnit timeUnit = TimeUnit.SECONDS;
    private int maxRetry = 3;

    @URL(message="{setup.ConnectionSettings.url.error}")
    @NotNull(message="{setup.ConnectionSettings.url.error}")
    @NotBlank(message="{setup.ConnectionSettings.url.error}")
    @Size(min=1, message="{setup.ConnectionSettings.url.error}")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Min(value=1L, message="{setup.ConnectionSettings.timeout.error}")
    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @NotNull(message="{setup.ConnectionSettings.timeUnit.null}")
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    @Min(value=1L, message="{setup.ConnectionSettings.retry.error}")
    @Max(value=5L, message="{setup.ConnectionSettings.retry.error}")
    public int getMaxRetry() {
        return this.maxRetry;
    }

    public void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).append("url", (Object)this.getUrl()).append("timeout", this.getTimeout()).append("time-unit", (Object)this.getTimeUnit()).append("max-retry", this.getMaxRetry()).toString();
    }
}

