/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.setup;

import java.io.File;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import reconf.client.setup.DatabaseURL;
import reconf.client.setup.LocalCacheSettings;
import reconf.infra.i18n.MessagesBundle;
import reconf.infra.log.LoggerHolder;
import reconf.infra.shutdown.ShutdownBean;
import reconf.infra.shutdown.ShutdownInterceptor;
import reconf.infra.throwables.ReConfInitializationError;

public class DatabaseManager
implements ShutdownBean {
    private static final MessagesBundle msg = MessagesBundle.getBundle(DatabaseManager.class);
    private final File directory;
    private final BasicDataSource dataSource;
    private final String DEFINITIVE_INSERT = "INSERT INTO PUBLIC.CLS_METHOD_PROP_VALUE_V2 (NAM_CLASS, NAM_METHOD, FULL_PROP, VALUE, UPDATED) VALUES (?,?,?,?,?)";
    private final String TEMPORARY_INSERT = "INSERT INTO PUBLIC.CLS_METHOD_PROP_VALUE_V2 (NAM_CLASS, NAM_METHOD, FULL_PROP, NEW_VALUE, UPDATED) VALUES (?,?,?,?,?)";
    private final String DEFINITIVE_UPDATE = "UPDATE PUBLIC.CLS_METHOD_PROP_VALUE_V2 SET VALUE = ?, UPDATED = ? WHERE FULL_PROP = ? AND NAM_CLASS = ? AND NAM_METHOD = ?";
    private final String TEMPORARY_UPDATE = "UPDATE PUBLIC.CLS_METHOD_PROP_VALUE_V2 SET NEW_VALUE = ?, UPDATED = ? WHERE FULL_PROP = ? AND NAM_CLASS = ? AND NAM_METHOD = ?";
    private final String COMMIT_TEMP_CHANGES = "UPDATE PUBLIC.CLS_METHOD_PROP_VALUE_V2 SET VALUE = NEW_VALUE, NEW_VALUE = NULL, UPDATED = ? WHERE FULL_PROP IN (%s) AND NAM_CLASS = ? AND NEW_VALUE IS NOT NULL";

    public DatabaseManager(LocalCacheSettings config) {
        new ShutdownInterceptor((ShutdownBean)this).register();
        try {
            if (null == config) {
                throw new ReConfInitializationError(msg.get("error.dir.not.provided"));
            }
            this.directory = config.getBackupLocation();
            this.provisionBackupDirectory();
            DatabaseURL url = DatabaseURL.location(this.directory.getPath()).encrypted();
            if (config.isCompressed()) {
                url = url.compressed();
            }
            if (config.getMaxLogFileSize() > 0) {
                url = url.maxLogFileSize(config.getMaxLogFileSize());
            }
            this.firstConnection(url);
            this.dataSource = this.createDataSource(url);
            if (!this.tableExists()) {
                this.createTable();
            }
        }
        catch (Throwable t) {
            throw new ReConfInitializationError(t);
        }
    }

    private void provisionBackupDirectory() {
        LoggerHolder.getLog().info(msg.format("setup.local.dir", new Object[]{this.directory}));
        if (this.directory.isFile()) {
            throw new ReConfInitializationError(msg.format("error.local.dir.file", new Object[]{this.directory}));
        }
        if (!this.directory.exists()) {
            LoggerHolder.getLog().info(msg.format("local.dir.not.found", new Object[]{this.directory}));
            try {
                FileUtils.forceMkdir((File)this.directory);
            }
            catch (Exception e) {
                throw new ReConfInitializationError((Throwable)e);
            }
            LoggerHolder.getLog().info(msg.format("local.dir.new", new Object[]{this.directory}));
        }
        if (!this.directory.canRead()) {
            throw new ReConfInitializationError(msg.format("error.local.dir.read", new Object[]{this.directory}));
        }
        if (!this.directory.canWrite()) {
            throw new ReConfInitializationError(msg.format("error.local.dir.write", new Object[]{this.directory}));
        }
        File parent = this.directory.getParentFile();
        if (!parent.canRead()) {
            throw new ReConfInitializationError(msg.format("error.local.dir.read", new Object[]{parent}));
        }
        if (!parent.canWrite()) {
            throw new ReConfInitializationError(msg.format("error.local.dir.write", new Object[]{parent}));
        }
    }

    private BasicDataSource createDataSource(DatabaseURL arg) {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(arg.getDriverClassName());
        ds.setUrl(arg.buildRuntimeURL());
        ds.setUsername(arg.getLogin());
        ds.setPassword(arg.getPass());
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists() throws Exception {
        boolean bl;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            stmt.execute("SELECT 1                                     FROM   INFORMATION_SCHEMA.TABLES             WHERE  TABLE_CATALOG = 'PUBLIC'              AND    TABLE_SCHEMA = 'PUBLIC'               AND    TABLE_NAME='CLS_METHOD_PROP_VALUE_V2' ");
            bl = stmt.getResultSet().next();
        }
        catch (Throwable throwable) {
            DatabaseManager.close(stmt);
            DatabaseManager.close(conn);
            throw throwable;
        }
        DatabaseManager.close(stmt);
        DatabaseManager.close(conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String fullProperty, Method method) {
        String string;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            conn = this.getConnection();
            stmt = conn.prepareStatement("SELECT VALUE                           FROM   PUBLIC.CLS_METHOD_PROP_VALUE_V2 WHERE  FULL_PROP = ?                   AND    NAM_CLASS = ?                   AND    NAM_METHOD = ?                  ");
            stmt.setString(1, StringUtils.upperCase((String)fullProperty));
            stmt.setString(2, method.getDeclaringClass().getName());
            stmt.setString(3, method.getName());
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            String string2 = rs.getClob(1) == null ? null : (rs.getClob(1).getCharacterStream() == null ? null : IOUtils.toString((Reader)rs.getClob(1).getCharacterStream()));
            DatabaseManager.close(rs);
            DatabaseManager.close(stmt);
            DatabaseManager.close(conn);
            return string2;
        }
        try {
            string = null;
        }
        catch (Exception e) {
            String string3;
            try {
                LoggerHolder.getLog().warn(msg.format("error.db", new Object[]{"get"}), (Throwable)e);
                string3 = null;
            }
            catch (Throwable throwable) {
                DatabaseManager.close(rs);
                DatabaseManager.close(stmt);
                DatabaseManager.close(conn);
                throw throwable;
            }
            DatabaseManager.close(rs);
            DatabaseManager.close(stmt);
            DatabaseManager.close(conn);
            return string3;
        }
        DatabaseManager.close(rs);
        DatabaseManager.close(stmt);
        DatabaseManager.close(conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getProductComponentPropertyValue() {
        HashMap<String, String> result = new HashMap<String, String>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement("SELECT FULL_PROP, VALUE FROM PUBLIC.CLS_METHOD_PROP_VALUE_V2");
            rs = stmt.executeQuery();
            while (rs.next()) {
                result.put(rs.getString("FULL_PROP"), rs.getString("VALUE"));
            }
        }
        catch (Exception e) {
            Map map;
            try {
                LoggerHolder.getLog().warn(msg.format("error.db", new Object[]{"getProductComponentPropertyValue"}), (Throwable)e);
                map = Collections.EMPTY_MAP;
            }
            catch (Throwable throwable) {
                DatabaseManager.close(rs);
                DatabaseManager.close(stmt);
                DatabaseManager.close(conn);
                throw throwable;
            }
            DatabaseManager.close(rs);
            DatabaseManager.close(stmt);
            DatabaseManager.close(conn);
            return map;
        }
        DatabaseManager.close(rs);
        DatabaseManager.close(stmt);
        DatabaseManager.close(conn);
        return result;
    }

    public void upsert(String fullProperty, Method method, String value) {
        this.innerUpsert(fullProperty, method, value, true);
    }

    public void temporaryUpsert(String fullProperty, Method method, String value) {
        this.innerUpsert(fullProperty, method, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerUpsert(String fullProperty, Method method, String value, boolean definitive) {
        BasicDataSource basicDataSource = this.dataSource;
        synchronized (basicDataSource) {
            if (this.dataSource.isClosed()) {
                return;
            }
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.getConnection();
            if (this.needToInsert(fullProperty, method)) {
                stmt = conn.prepareStatement(definitive ? "INSERT INTO PUBLIC.CLS_METHOD_PROP_VALUE_V2 (NAM_CLASS, NAM_METHOD, FULL_PROP, VALUE, UPDATED) VALUES (?,?,?,?,?)" : "INSERT INTO PUBLIC.CLS_METHOD_PROP_VALUE_V2 (NAM_CLASS, NAM_METHOD, FULL_PROP, NEW_VALUE, UPDATED) VALUES (?,?,?,?,?)");
                stmt.setString(1, method.getDeclaringClass().getName());
                stmt.setString(2, method.getName());
                stmt.setString(3, StringUtils.upperCase((String)fullProperty));
                stmt.setString(4, value);
                stmt.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            } else {
                stmt = conn.prepareStatement(definitive ? "UPDATE PUBLIC.CLS_METHOD_PROP_VALUE_V2 SET VALUE = ?, UPDATED = ? WHERE FULL_PROP = ? AND NAM_CLASS = ? AND NAM_METHOD = ?" : "UPDATE PUBLIC.CLS_METHOD_PROP_VALUE_V2 SET NEW_VALUE = ?, UPDATED = ? WHERE FULL_PROP = ? AND NAM_CLASS = ? AND NAM_METHOD = ?");
                stmt.setString(1, value);
                stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                stmt.setString(3, StringUtils.upperCase((String)fullProperty));
                stmt.setString(4, method.getDeclaringClass().getName());
                stmt.setString(5, method.getName());
            }
            if (0 == stmt.executeUpdate()) {
                throw new IllegalStateException(msg.get("error.db.update.zero"));
            }
        }
        catch (Exception e) {
            try {
                LoggerHolder.getLog().warn(msg.format("error.db", new Object[]{definitive ? "upsert" : "temporaryUpsert"}), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseManager.close(stmt);
                DatabaseManager.close(conn);
                throw throwable;
            }
        }
        DatabaseManager.close(stmt);
        DatabaseManager.close(conn);
    }

    private boolean needToInsert(String fullProperty, Method method) {
        boolean bl;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            conn = this.getConnection();
            stmt = conn.prepareStatement("SELECT 1                               FROM   PUBLIC.CLS_METHOD_PROP_VALUE_V2 WHERE  FULL_PROP = ?                   AND    NAM_CLASS = ?                   AND    NAM_METHOD = ?                  ");
            stmt.setString(1, StringUtils.upperCase((String)fullProperty));
            stmt.setString(2, method.getDeclaringClass().getName());
            stmt.setString(3, method.getName());
            rs = stmt.executeQuery();
            if (!rs.next()) break block5;
            boolean bl2 = false;
            DatabaseManager.close(rs);
            DatabaseManager.close(stmt);
            DatabaseManager.close(conn);
            return bl2;
        }
        try {
            bl = true;
        }
        catch (Exception e) {
            try {
                LoggerHolder.getLog().warn(msg.format("error.db", new Object[]{"needToInsert"}), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseManager.close(rs);
                DatabaseManager.close(stmt);
                DatabaseManager.close(conn);
                throw throwable;
            }
        }
        DatabaseManager.close(rs);
        DatabaseManager.close(stmt);
        DatabaseManager.close(conn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTemporaryUpdate(Collection<String> fullProperties, Class<?> declaringClass) {
        BasicDataSource basicDataSource = this.dataSource;
        synchronized (basicDataSource) {
            if (this.dataSource.isClosed()) {
                return;
            }
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        String qry = String.format("UPDATE PUBLIC.CLS_METHOD_PROP_VALUE_V2 SET VALUE = NEW_VALUE, NEW_VALUE = NULL, UPDATED = ? WHERE FULL_PROP IN (%s) AND NAM_CLASS = ? AND NEW_VALUE IS NOT NULL", StringUtils.join(this.toUpper(fullProperties), (String)","));
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(qry);
            stmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            stmt.setString(2, declaringClass.getName());
            int changed = stmt.executeUpdate();
            LoggerHolder.getLog().debug(msg.format("db.update.number", new Object[]{changed}));
        }
        catch (Exception e) {
            try {
                LoggerHolder.getLog().warn(msg.format("error.db", new Object[]{"commitTemporaryUpdate"}), (Throwable)e);
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                DatabaseManager.close(stmt);
                DatabaseManager.close(conn);
                throw throwable;
            }
        }
        DatabaseManager.close(stmt);
        DatabaseManager.close(conn);
    }

    private Collection<String> toUpper(Collection<String> arg) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String str : arg) {
            result.add("'" + StringUtils.upperCase((String)str) + "'");
        }
        return result;
    }

    private void createTable() throws Exception {
        this.execute("CREATE TABLE PUBLIC.CLS_METHOD_PROP_VALUE_V2     (NAM_CLASS VARCHAR(255) NOT NULL,                 NAM_METHOD VARCHAR(255) NOT NULL,                FULL_PROP LONGVARCHAR NOT NULL,                  VALUE LONGVARCHAR,                               NEW_VALUE LONGVARCHAR,                           UPDATED TIMESTAMP,                               PRIMARY KEY (NAM_CLASS, NAM_METHOD, FULL_PROP)) ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void execute(String cmd) throws Exception {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement();
            stmt.execute(cmd);
        }
        catch (Throwable throwable) {
            DatabaseManager.close(stmt);
            DatabaseManager.close(conn);
            throw throwable;
        }
        DatabaseManager.close(stmt);
        DatabaseManager.close(conn);
    }

    public static void close(Statement arg) {
        if (null == arg) {
            return;
        }
        try {
            arg.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(ResultSet arg) {
        if (null == arg) {
            return;
        }
        try {
            arg.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(Connection arg) {
        if (null == arg) {
            return;
        }
        try {
            arg.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized Connection getConnection() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        conn.setAutoCommit(true);
        return conn;
    }

    private synchronized void firstConnection(DatabaseURL arg) throws SQLException {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(arg.getDriverClassName());
        ds.setUrl(arg.buildInitalURL());
        ds.setUsername(arg.getLogin());
        ds.setPassword(arg.getPass());
        ds.getConnection().close();
    }

    public synchronized void shutdown() {
        try {
            LoggerHolder.getLog().info(msg.get("db.stopping"));
            this.execute("SHUTDOWN");
            if (this.dataSource != null) {
                this.dataSource.close();
            }
            LoggerHolder.getLog().info(msg.get("db.stopped"));
        }
        catch (Exception ignored) {
            LoggerHolder.getLog().warn(msg.get("error.db.stopping"), (Throwable)ignored);
        }
    }
}

