/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.setup;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import reconf.infra.i18n.MessagesBundle;

public class DatabaseURL {
    private static final MessagesBundle msg = MessagesBundle.getBundle(DatabaseURL.class);
    private static final String baseURL = "jdbc:hsqldb:file:";
    private static final String driverClassName = "org.hsqldb.jdbc.JDBCDriver";
    private String location;
    private Map<String, String> initialParams = new LinkedHashMap<String, String>();
    private Map<String, String> runtimeParams = new LinkedHashMap<String, String>();
    private static final String cryptKey;
    private static final Map<String, String> baseParams;
    private static final Map<String, String> cryptParams;
    private static final Map<String, String> baseInitialParams;
    private static final Map<String, String> baseRuntimeParams;

    private DatabaseURL() {
    }

    static DatabaseURL location(String arg) {
        DatabaseURL dbURL = new DatabaseURL();
        dbURL.location = arg;
        dbURL.initialParams.putAll(baseInitialParams);
        dbURL.runtimeParams.putAll(baseRuntimeParams);
        return dbURL;
    }

    DatabaseURL encrypted() {
        this.initialParams.putAll(cryptParams);
        this.runtimeParams.putAll(cryptParams);
        return this;
    }

    DatabaseURL notEncrypted() {
        this.initialParams.putAll(baseInitialParams);
        this.runtimeParams.putAll(baseRuntimeParams);
        return this;
    }

    DatabaseURL compressed() {
        this.initialParams.put("hsqldb.script_format", "3");
        this.runtimeParams.put("hsqldb.script_format", "3");
        return this;
    }

    DatabaseURL notCompressed() {
        this.initialParams.put("hsqldb.script_format", "0");
        this.runtimeParams.put("hsqldb.script_format", "0");
        return this;
    }

    DatabaseURL maxLogFileSize(int size) {
        this.initialParams.put("hsqldb.log_size", String.valueOf(size));
        this.runtimeParams.put("hsqldb.script_format", String.valueOf(size));
        return this;
    }

    String buildInitalURL() {
        return baseURL + this.location + this.buildString(this.initialParams);
    }

    String buildRuntimeURL() {
        return baseURL + this.location + this.buildString(this.runtimeParams);
    }

    private String buildString(Map<String, String> params) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> each : params.entrySet()) {
            result.add(each.getKey() + "=" + each.getValue());
        }
        return ";" + StringUtils.join(result, (String)";");
    }

    String getDriverClassName() {
        return driverClassName;
    }

    String getLogin() {
        return "reconfdb";
    }

    String getPass() {
        return "local";
    }

    static {
        try {
            SecretKeySpec key = new SecretKeySpec("abcdefghijklmnop".getBytes(), "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, key);
            cryptKey = new String(Hex.encodeHex((byte[])cipher.doFinal("remoteconfigdb".getBytes())));
        }
        catch (Exception e) {
            throw new Error(msg.get("error.crypt.key"));
        }
        baseParams = new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("hsqldb.lock_file", "false");
                this.put("shutdown", "true");
            }
        };
        cryptParams = new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("crypt_key", cryptKey);
                this.put("crypt_type", "AES");
                this.put("crypt_lobs", "true");
            }
        };
        baseInitialParams = new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.putAll(baseParams);
            }
        };
        baseRuntimeParams = new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.putAll(baseParams);
                this.put("ifexists", "true");
            }
        };
    }
}

