/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.setup;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import reconf.client.factory.ConfigurationRepositoryElementFactory;
import reconf.client.setup.DatabaseManager;
import reconf.client.setup.XmlConfiguration;
import reconf.client.setup.XmlConfigurationParser;
import reconf.infra.http.LocalHostname;
import reconf.infra.i18n.ClassValidatorFactory;
import reconf.infra.i18n.LocaleHolder;
import reconf.infra.i18n.MessagesBundle;
import reconf.infra.io.ClasspathReader;
import reconf.infra.io.InputStreamReader;
import reconf.infra.log.LoggerHolder;
import reconf.infra.system.LineSeparator;
import reconf.infra.throwables.ReConfInitializationError;

public class Environment {
    private static final String RECONF_DEFAULT_FILE = "reconf.xml";
    private static final String SYSTEM_PROPERTY = "reconf.client.xml.location";
    private static final XmlConfiguration config;
    private static final ConfigurationRepositoryElementFactory factory;
    private static DatabaseManager mgr;
    private static MessagesBundle msg;

    private static void validate(XmlConfiguration xmlConfig) {
        if (xmlConfig == null) {
            throw new ReConfInitializationError(msg.get("error.internal"));
        }
        Set violations = ClassValidatorFactory.create(Environment.class).validate((Object)xmlConfig, new Class[0]);
        if (CollectionUtils.isEmpty((Collection)violations)) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        int i = 1;
        for (ConstraintViolation violation : violations) {
            errors.add(i++ + " - " + violation.getMessage());
        }
        throw new ReConfInitializationError(msg.format("error.xml", new Object[]{LineSeparator.value(), StringUtils.join(errors, (String)LineSeparator.value())}));
    }

    public static void setUp() {
        LoggerHolder.getLog().info(msg.get("start"));
    }

    public static DatabaseManager getManager() {
        return mgr;
    }

    public static ConfigurationRepositoryElementFactory getFactory() {
        return factory;
    }

    static {
        try {
            String raw = null;
            String prop = System.getProperty(SYSTEM_PROPERTY);
            if (StringUtils.isNotBlank((String)prop)) {
                LoggerHolder.getLog().info(String.format("system property [%] found. trying to read file [%s]", SYSTEM_PROPERTY, prop));
                raw = InputStreamReader.read((InputStream)new FileInputStream(new File(prop)));
            } else {
                LoggerHolder.getLog().info(String.format("trying to read file [%s] from classpath", RECONF_DEFAULT_FILE));
                raw = ClasspathReader.read((String)RECONF_DEFAULT_FILE);
            }
            if (StringUtils.isBlank((String)raw)) {
                throw new ReConfInitializationError("configuration file is either empty or could not be found");
            }
            XmlConfigurationParser parser = XmlConfigurationParser.from(raw);
            LocaleHolder.set((String)parser.getLocale());
            config = new XmlConfiguration();
            config.setAnnotationOverride(parser.getAnnotationOverride());
            config.setConnectionSettings(parser.getConnectionSettings());
            config.setLocalCacheSettings(parser.getLocalCacheSettings());
            msg = MessagesBundle.getBundle(Environment.class);
            LoggerHolder.getLog().info(msg.get("file.load"));
            Environment.validate(config);
            LoggerHolder.getLog().info(msg.format("configured", new Object[]{LineSeparator.value(), config.toString()}));
            factory = new ConfigurationRepositoryElementFactory(config);
            LoggerHolder.getLog().info(msg.get("db.setup"));
            mgr = new DatabaseManager(config.getLocalCacheSettings());
            LoggerHolder.getLog().info(msg.format("instance.name", new Object[]{LocalHostname.getName()}));
        }
        catch (ReConfInitializationError e) {
            if (mgr != null) {
                mgr.shutdown();
            }
            throw e;
        }
        catch (Throwable t) {
            if (mgr != null) {
                mgr.shutdown();
            }
            throw new ReConfInitializationError(t);
        }
    }
}

