/*
 * Decompiled with CFR 0.152.
 */
package reconf.client.setup;

import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import reconf.client.setup.ConnectionSettings;
import reconf.client.setup.GlobalUpdateFrequencySettings;
import reconf.client.setup.LocalCacheSettings;
import reconf.infra.log.LoggerHolder;
import reconf.infra.system.LineSeparator;
import reconf.infra.throwables.ReConfInitializationError;

public class XmlConfigurationParser
extends DefaultHandler {
    private String temp;
    private String tag;
    private String locale;
    private LocalCacheSettings localCacheSettings;
    private boolean openLocalCacheSettings;
    private boolean begin = false;
    private ConnectionSettings connectionSettings;
    private boolean openConnectionSettings;
    private GlobalUpdateFrequencySettings annotationOverride;
    private boolean openAnnotationOverride;

    public static XmlConfigurationParser from(String xmlContent) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XmlConfigurationParser reader = new XmlConfigurationParser();
            parser.parse(IOUtils.toInputStream((String)xmlContent), (DefaultHandler)reader);
            if (!reader.begin) {
                LoggerHolder.getLog().error("error parsing the configuration file. check if the file is valid");
            }
            return reader;
        }
        catch (Exception e) {
            throw new ReConfInitializationError("error parsing the configuration file with content" + LineSeparator.value() + xmlContent, e);
        }
    }

    @Override
    public void characters(char[] buffer, int start, int length) {
        if (!this.begin) {
            return;
        }
        this.temp = new String(buffer, start, length);
        if (this.openLocalCacheSettings) {
            this.buildLocalCacheSettings();
        }
        if (this.openConnectionSettings) {
            this.buildConnectionSettings();
        }
        if (this.openAnnotationOverride) {
            this.buildAnnotationOverride();
        }
    }

    private void buildLocalCacheSettings() {
        if (StringUtils.equalsIgnoreCase((String)"location", (String)this.tag)) {
            File file = null;
            try {
                file = new File(this.temp);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.localCacheSettings.setBackupLocation(file);
        }
        if (StringUtils.equalsIgnoreCase((String)"max-log-file-size-mb", (String)this.tag)) {
            this.localCacheSettings.setMaxLogFileSize(this.tempAsInteger());
        }
        if (StringUtils.equalsIgnoreCase((String)"compressed", (String)this.tag)) {
            Boolean bool = null;
            try {
                bool = Boolean.valueOf(this.temp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.localCacheSettings.setCompressed(bool);
        }
    }

    private void buildConnectionSettings() {
        if (StringUtils.equalsIgnoreCase((String)"url", (String)this.tag)) {
            this.connectionSettings.setUrl(this.temp);
        }
        if (StringUtils.equalsIgnoreCase((String)"timeout", (String)this.tag)) {
            this.connectionSettings.setTimeout(this.tempAsInteger());
        }
        if (StringUtils.equalsIgnoreCase((String)"time-unit", (String)this.tag)) {
            this.connectionSettings.setTimeUnit(this.tempAsTimeUnit());
        }
        if (StringUtils.equalsIgnoreCase((String)"max-retry", (String)this.tag)) {
            this.connectionSettings.setMaxRetry(this.tempAsInteger());
        }
    }

    private void buildAnnotationOverride() {
        if (StringUtils.equalsIgnoreCase((String)"interval", (String)this.tag)) {
            this.annotationOverride.setInterval(this.tempAsInteger());
        }
        if (StringUtils.equalsIgnoreCase((String)"time-unit", (String)this.tag)) {
            this.annotationOverride.setTimeUnit(this.tempAsTimeUnit());
        }
    }

    private Integer tempAsInteger() {
        Integer integer = null;
        try {
            integer = Integer.valueOf(this.temp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return integer;
    }

    private TimeUnit tempAsTimeUnit() {
        TimeUnit timeUnit = null;
        try {
            timeUnit = TimeUnit.valueOf(this.temp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeUnit;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tag = qName;
        if (!this.begin && StringUtils.equalsIgnoreCase((String)"configuration", (String)qName)) {
            this.begin = true;
        }
        if (StringUtils.equalsIgnoreCase((String)"local-cache", (String)qName)) {
            this.localCacheSettings = new LocalCacheSettings();
            this.openLocalCacheSettings = true;
        }
        if (StringUtils.equalsIgnoreCase((String)"server", (String)qName)) {
            this.connectionSettings = new ConnectionSettings();
            this.openConnectionSettings = true;
        }
        if (StringUtils.equalsIgnoreCase((String)"configuration-repository-update-frequency", (String)qName)) {
            this.annotationOverride = new GlobalUpdateFrequencySettings();
            this.openAnnotationOverride = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.begin) {
            return;
        }
        this.tag = "";
        if (StringUtils.equalsIgnoreCase((String)"locale", (String)qName)) {
            this.locale = this.temp;
        }
        if (StringUtils.equalsIgnoreCase((String)"local-cache", (String)qName)) {
            this.openLocalCacheSettings = false;
        }
        if (StringUtils.equalsIgnoreCase((String)"server", (String)qName)) {
            this.openConnectionSettings = false;
        }
        if (StringUtils.equalsIgnoreCase((String)"configuration-repository-update-frequency", (String)qName)) {
            this.openAnnotationOverride = false;
        }
    }

    public LocalCacheSettings getLocalCacheSettings() {
        return this.localCacheSettings;
    }

    public ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public GlobalUpdateFrequencySettings getAnnotationOverride() {
        return this.annotationOverride;
    }

    public String getLocale() {
        return this.locale;
    }
}

