/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.http;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;

public class LocalHostname {
    public static String getName() {
        String runtime = LocalHostname.runtimeStrategy();
        String fallback = LocalHostname.fallbackStrategy();
        return runtime != null ? runtime : (fallback != null ? fallback : "");
    }

    private static String fallbackStrategy() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runtimeStrategy() {
        BufferedReader in = null;
        try {
            Process proc = Runtime.getRuntime().exec("hostname");
            proc.waitFor();
            in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String string = in.readLine();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

