/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.http;

import java.util.concurrent.TimeUnit;
import reconf.infra.http.LocalHostname;
import reconf.infra.http.SimpleHttpDelegatorFactory;
import reconf.infra.http.layer.SimpleHttpRequest;
import reconf.infra.http.layer.SimpleHttpResponse;
import reconf.infra.i18n.MessagesBundle;

public class ServerStub {
    private static final MessagesBundle msg = MessagesBundle.getBundle(ServerStub.class);
    private static final String PROTOCOL = "reconf.client-v1+text/plain";
    private SimpleHttpDelegatorFactory factory;
    private final String serviceUri;
    private final long timeout;
    private final TimeUnit timeunit;
    private final int maxRetry;
    private String product;
    private String component;
    private String instance;

    public ServerStub(String serviceUri, long timeout, TimeUnit timeUnit, int maxRetry) {
        this(serviceUri, timeout, timeUnit, maxRetry, SimpleHttpDelegatorFactory.defaultImplementation);
    }

    public ServerStub(String serviceUri, long timeout, TimeUnit timeUnit, int maxRetry, SimpleHttpDelegatorFactory factory) {
        this.serviceUri = serviceUri;
        this.timeout = timeout;
        this.timeunit = timeUnit;
        this.instance = LocalHostname.getName();
        this.maxRetry = maxRetry;
        this.factory = factory;
    }

    public String get(String property) throws Exception {
        SimpleHttpRequest httpGet = this.factory.newGetRequest(this.serviceUri, this.product, this.component, property).addQueryParam("instance", this.instance).addHeaderField("Accept-Encoding", "gzip,deflate").addHeaderField("X-ReConf-Protocol", PROTOCOL);
        int status = 0;
        try {
            SimpleHttpResponse result = this.factory.executeAvoidingSSL(httpGet, this.timeout, this.timeunit, this.maxRetry);
            status = result.getStatusCode();
            if (status == 200) {
                return result.getBodyAsString();
            }
        }
        catch (Exception e) {
            if (status == 0) {
                throw new IllegalStateException(msg.format("error.generic", httpGet.getURI()), e);
            }
            throw new IllegalStateException(msg.format("error.http", status, httpGet.getURI()), e);
        }
        throw new IllegalStateException(msg.format("error.generic", httpGet.getURI()));
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }
}

