/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.http.layer;

import java.io.IOException;
import java.net.SocketException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.protocol.HttpContext;

public class RetryHandler
implements HttpRequestRetryHandler {
    private int maxRetry = 3;

    public RetryHandler(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        boolean idempotent;
        if (exception instanceof SocketException && executionCount <= 1) {
            return true;
        }
        if (executionCount >= this.maxRetry) {
            return false;
        }
        if (exception instanceof NoHttpResponseException) {
            return true;
        }
        if (exception instanceof SSLHandshakeException) {
            return false;
        }
        HttpRequest request = (HttpRequest)context.getAttribute("http.request");
        boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
        return idempotent;
    }
}

