/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.http.layer;

import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import reconf.infra.http.layer.RequestTask;
import reconf.infra.http.layer.RetryHandler;
import reconf.infra.http.layer.SimpleHttpRequest;
import reconf.infra.http.layer.SimpleHttpResponse;
import reconf.infra.i18n.MessagesBundle;

public class SimpleHttpClient {
    private static final MessagesBundle msg = MessagesBundle.getBundle(SimpleHttpClient.class);
    private static final ExecutorService requestExecutor = Executors.newCachedThreadPool();

    public static SimpleHttpRequest newGetRequest(String pathBase, String ... pathParam) throws URISyntaxException {
        return new SimpleHttpRequest("GET", pathBase, pathParam);
    }

    public static SimpleHttpResponse executeAvoidingSSL(SimpleHttpRequest request, long timeout, TimeUnit timeunit, int retries) throws Exception {
        return SimpleHttpClient.execute((HttpClient)SimpleHttpClient.newHttpClientAvoidSSL(timeout, timeunit, retries), request, timeout, timeunit);
    }

    private static SimpleHttpResponse execute(HttpClient httpClient, SimpleHttpRequest request, long timeout, TimeUnit timeunit) throws Exception {
        RequestTask task = new RequestTask(httpClient, (HttpUriRequest)request);
        Future<SimpleHttpResponse> futureResponse = requestExecutor.submit(task);
        try {
            SimpleHttpResponse simpleHttpResponse = futureResponse.get(timeout, timeunit);
            return simpleHttpResponse;
        }
        catch (TimeoutException e) {
            httpClient.getConnectionManager().shutdown();
            RequestLine line = request.getRequestLine();
            String method = request.getMethod();
            if (line != null && method != null) {
                throw new TimeoutException(msg.format("error.complete", method.toUpperCase(), line.getUri(), timeout, timeunit.toString().toLowerCase()));
            }
            throw new TimeoutException(msg.format("error", timeout, timeunit.toString().toLowerCase()));
        }
        catch (ExecutionException e) {
            httpClient.getConnectionManager().shutdown();
            throw e;
        }
        catch (InterruptedException e) {
            httpClient.getConnectionManager().shutdown();
            throw e;
        }
        finally {
            if (futureResponse != null) {
                futureResponse.cancel(true);
            }
        }
    }

    private static DefaultHttpClient newHttpClientAvoidSSL(long timeout, TimeUnit timeUnit, int retries) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager connectionManager = new DefaultHttpClient().getConnectionManager();
        connectionManager.getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        DefaultHttpClient httpClient = new DefaultHttpClient(connectionManager, SimpleHttpClient.createBasicHttpParams(timeout, timeUnit));
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(retries));
        return httpClient;
    }

    private static HttpParams createBasicHttpParams(long timeout, TimeUnit timeunit) {
        int timemillis = (int)TimeUnit.MILLISECONDS.convert(timeout, timeunit);
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)timemillis);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)timemillis);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        return params;
    }
}

