/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.http.layer;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.utils.URIBuilder;

public class SimpleHttpRequest
extends HttpEntityEnclosingRequestBase {
    private final String httpMethod;
    private int queryParams = -1;

    SimpleHttpRequest(String method, String pathBase, String ... pathParam) throws URISyntaxException {
        this.httpMethod = method;
        URIBuilder baseBuilder = new URIBuilder(pathBase);
        if (baseBuilder.getScheme() == null) {
            baseBuilder = new URIBuilder("http://" + pathBase);
        }
        StringBuilder pathBuilder = new StringBuilder(baseBuilder.getPath());
        for (String param : pathParam) {
            pathBuilder.append("/").append(param);
        }
        this.setURI(new URI(baseBuilder.getScheme(), baseBuilder.getUserInfo(), baseBuilder.getHost(), baseBuilder.getPort(), pathBuilder.toString(), null, null));
    }

    public SimpleHttpRequest addQueryParam(String paramName, String paramValue) {
        String newUri = ++this.queryParams > 0 ? String.format("%s&%s=%s", this.getURI().toASCIIString(), paramName, this.encode(paramValue)) : String.format("%s?%s=%s", this.getURI().toASCIIString(), paramName, this.encode(paramValue));
        this.setURI(URI.create(newUri));
        return this;
    }

    public SimpleHttpRequest addHeaderField(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    private String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    public String getMethod() {
        return this.httpMethod;
    }
}

