/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.http.layer;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import reconf.infra.system.LineSeparator;

public class SimpleHttpResponse {
    public static final String CHARSET_DEFAULT = "UTF-8";
    private final HttpResponse response;
    private final HttpClient httpClient;
    private String body = null;

    SimpleHttpResponse(HttpClient httpClient, HttpUriRequest request) throws ClientProtocolException, IOException {
        this.httpClient = httpClient;
        this.response = httpClient.execute(request);
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBodyAsString() throws IOException {
        if (this.body == null) {
            HttpEntity entity = this.response.getEntity();
            if (entity == null) {
                this.body = "";
                return "";
            }
            String encoding = SimpleHttpResponse.getContentEncoding(entity);
            String charset = SimpleHttpResponse.getContentCharSet(entity);
            try {
                if ("gzip".equalsIgnoreCase(encoding)) {
                    GzipDecompressingEntity gzip = new GzipDecompressingEntity(entity);
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    gzip.writeTo((OutputStream)output);
                    this.body = output.toString(charset);
                } else {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), charset));
                    StringBuilder result = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                        if (!reader.ready()) continue;
                        result.append(LineSeparator.value());
                    }
                    this.body = result.toString();
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)entity);
                this.httpClient.getConnectionManager().shutdown();
            }
        }
        return this.body;
    }

    public static String getContentCharSet(HttpEntity entity) {
        Header type;
        if (entity != null && (type = entity.getContentType()) != null) {
            for (HeaderElement headerElement : type.getElements()) {
                if (!"charset".equalsIgnoreCase(headerElement.getName())) continue;
                return headerElement.getValue();
            }
        }
        return CHARSET_DEFAULT;
    }

    public static String getContentEncoding(HttpEntity entity) {
        Header encoding;
        if (entity != null && (encoding = entity.getContentEncoding()) != null) {
            return encoding.getValue();
        }
        return "";
    }

    public String toString() {
        if (this.response == null) {
            return "null";
        }
        return this.response.toString();
    }
}

