/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.i18n;

import org.apache.commons.lang.StringUtils;

public class BundleSettings {
    private final String className;
    private final String headPackageName;
    private final String tailPackageName;

    public BundleSettings(Class<?> cls) {
        this.className = cls.getSimpleName();
        String[] packages = StringUtils.split((String)cls.getPackage().getName(), (char)'.');
        if (packages.length == 0 || packages.length == 1) {
            throw new IllegalArgumentException("only meant to be used inside reconf");
        }
        this.headPackageName = packages[1];
        this.tailPackageName = packages.length >= 2 ? StringUtils.substringAfter((String)cls.getPackage().getName(), (String)("reconf." + this.headPackageName + ".")) : "";
    }

    public String getClassName() {
        return this.className;
    }

    public String getHeadPackageName() {
        return this.headPackageName;
    }

    public String getTailPackageName() {
        return this.tailPackageName;
    }

    public String getBundleResourceName() {
        return "messages_" + this.getHeadPackageName();
    }
}

