/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.i18n;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.ResourceBundleLocator;
import reconf.infra.i18n.BundleSettings;
import reconf.infra.i18n.LocaleHolder;

public class ClassValidatorFactory
implements ResourceBundleLocator {
    private BundleSettings settings;

    private ClassValidatorFactory(Class<?> cls) {
        this.settings = new BundleSettings(cls);
    }

    public ResourceBundle getResourceBundle(Locale ignored) {
        return ResourceBundle.getBundle(this.settings.getBundleResourceName(), LocaleHolder.value());
    }

    public static Validator create(Class<?> cls) {
        Configuration<?> configure = ClassValidatorFactory.getConfiguration();
        configure.messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)new ClassValidatorFactory(cls)));
        return ClassValidatorFactory.buildIt(configure).getValidator();
    }

    private static Configuration<?> getConfiguration() {
        return Validation.byDefaultProvider().configure();
    }

    private static ValidatorFactory buildIt(Configuration<?> configure) {
        return configure.buildValidatorFactory();
    }
}

