/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.i18n;

import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;
import reconf.infra.log.LoggerHolder;

public final class LocaleHolder {
    private static String providedLocale;

    public static void set(String value) {
        if (providedLocale == null) {
            providedLocale = value;
        }
    }

    public static Locale value() {
        if (StringUtils.isNotBlank((String)providedLocale)) {
            try {
                return LocaleUtils.toLocale((String)providedLocale);
            }
            catch (IllegalArgumentException e) {
                LoggerHolder.getLog().error(String.format("invalid locale [%s]. assuming default [%s]", providedLocale, Locale.getDefault()));
            }
        }
        return Locale.getDefault();
    }
}

