/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.i18n;

import java.util.Locale;
import java.util.ResourceBundle;
import reconf.infra.i18n.BundleSettings;
import reconf.infra.i18n.LocaleHolder;
import reconf.infra.log.LoggerHolder;

public class MessagesBundle {
    private ResourceBundle bundle;
    private final BundleSettings settings;

    private MessagesBundle(Class<?> cls) {
        Locale locale = LocaleHolder.value();
        LoggerHolder.getLog().debug("MessagesBundle locale [{}]", (Object)locale);
        this.settings = new BundleSettings(cls);
        this.bundle = ResourceBundle.getBundle(this.settings.getBundleResourceName(), locale);
    }

    public static MessagesBundle getBundle(Class<?> cls) {
        return new MessagesBundle(cls);
    }

    public String get(String key) {
        return this.bundle.getString(this.getPath(key));
    }

    public String format(String key, Object ... args) {
        return String.format(this.bundle.getString(this.getPath(key)), args);
    }

    private String getPath(String key) {
        return this.settings.getTailPackageName() + "." + this.settings.getClassName() + "." + key;
    }
}

