/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.io;

import java.io.InputStream;
import java.net.URI;
import reconf.infra.io.Closeables;
import reconf.infra.io.InputStreamReader;
import reconf.infra.io.RegExp;
import reconf.infra.log.LoggerHolder;

public class ClasspathReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(URI uri) {
        InputStream is;
        StringBuilder sb;
        block10: {
            if (null == uri) {
                return "";
            }
            sb = new StringBuilder();
            is = null;
            String name = RegExp.withoutSchemeAndParameters(uri);
            is = ClasspathReader.classLoader(name);
            if (null != is) break block10;
            is = ClasspathReader.currentThread(name);
            if (null == is) {
                is = ClasspathReader.newClass(name);
            }
            if (null == is) {
                is = ClasspathReader.classLoader("/" + name);
            }
            if (null == is) {
                is = ClasspathReader.currentThread("/" + name);
            }
            if (null == is) {
                is = ClasspathReader.newClass("/" + name);
            }
            if (null != is) break block10;
            String string = "";
            Closeables.closeQuietly(is);
            return string;
        }
        try {
            sb.append(InputStreamReader.read(is));
        }
        catch (Exception e) {
            try {
                LoggerHolder.getLog().error("error while reading a file from classpath", (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(is);
                throw throwable;
            }
            Closeables.closeQuietly(is);
        }
        Closeables.closeQuietly(is);
        return sb.toString();
    }

    private static InputStream classLoader(String arg) {
        return ClassLoader.getSystemResourceAsStream(arg);
    }

    private static InputStream currentThread(String arg) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(arg);
    }

    private static InputStream newClass(String arg) {
        return Class.class.getResourceAsStream(arg);
    }

    public static String read(String uri) {
        return ClasspathReader.read(URI.create(uri));
    }
}

