/*
 * Decompiled with CFR 0.152.
 */
package reconf.infra.io;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import reconf.infra.io.Closeables;
import reconf.infra.log.LoggerHolder;
import reconf.infra.system.LineSeparator;

public class InputStreamReader {
    public static String read(InputStream is) {
        if (null == is) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        List<String> lines = InputStreamReader.readLines(is);
        for (String line : lines) {
            sb.append(line).append(LineSeparator.value());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(InputStream is) {
        if (null == is) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            lines.addAll(IOUtils.readLines((InputStream)is));
        }
        catch (Exception e) {
            LoggerHolder.getLog().error("error while reading the inputstream", (Throwable)e);
        }
        finally {
            Closeables.closeQuietly(is);
        }
        return lines;
    }
}

