/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.configuration.Configuration;
import br.gov.frameworkdemoiselle.internal.bootstrap.CustomBean;
import br.gov.frameworkdemoiselle.internal.implementation.ConfigurationImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

public class ConfigurationBootstrap
implements Extension {
    private final List<Class<Object>> cache = Collections.synchronizedList(new ArrayList());
    private static final Map<ClassLoader, Map<String, Class<Object>>> cacheClassLoader = Collections.synchronizedMap(new HashMap());

    public void processAnnotatedType(@Observes ProcessAnnotatedType<Object> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        if (annotatedType.getJavaClass().isAnnotationPresent(Configuration.class)) {
            this.cache.add(annotatedType.getJavaClass());
            event.veto();
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) throws Exception {
        for (Class<Object> config : this.cache) {
            Class<Object> proxy = this.createProxy(config);
            event.addBean((Bean)new CustomBean(proxy, beanManager));
        }
    }

    private Class<Object> createProxy(Class<Object> type) throws Exception {
        String superClassName = type.getCanonicalName();
        String chieldClassName = superClassName + "__DemoiselleProxy";
        Map<Object, Object> cacheProxy = Collections.synchronizedMap(new HashMap());
        Class clazzProxy = null;
        ClassLoader classLoader = type.getClassLoader();
        if (cacheClassLoader.containsKey(classLoader) && (cacheProxy = cacheClassLoader.get(classLoader)).containsKey(chieldClassName)) {
            clazzProxy = (Class)cacheProxy.get(chieldClassName);
        }
        if (clazzProxy == null) {
            ClassPool pool = new ClassPool();
            CtClass ctChieldClass = pool.getOrNull(chieldClassName);
            pool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
            CtClass ctSuperClass = pool.get(superClassName);
            ctChieldClass = pool.getAndRename(ConfigurationImpl.class.getCanonicalName(), chieldClassName);
            ctChieldClass.setSuperclass(ctSuperClass);
            for (CtMethod ctSuperMethod : ctSuperClass.getDeclaredMethods()) {
                CtMethod ctChieldMethod = CtNewMethod.delegator((CtMethod)ctSuperMethod, (CtClass)ctChieldClass);
                ctChieldMethod.insertBefore("load(this);");
                ctChieldClass.addMethod(ctChieldMethod);
            }
            clazzProxy = ctChieldClass.toClass(classLoader, type.getProtectionDomain());
            cacheProxy.put(chieldClassName, clazzProxy);
            cacheClassLoader.put(classLoader, cacheProxy);
        }
        return clazzProxy;
    }
}

