/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.util.Beans;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;

public class CustomBean
implements Bean<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Class<Object> beanClass;
    private transient InjectionTarget<Object> injectionTarget;
    private transient BeanManager beanManager;

    private InjectionTarget<Object> getInjectionTarget() {
        if (this.injectionTarget == null) {
            AnnotatedType annotatedType = this.getBeanManager().createAnnotatedType(this.beanClass);
            this.injectionTarget = this.getBeanManager().createInjectionTarget(annotatedType);
        }
        return this.injectionTarget;
    }

    private BeanManager getBeanManager() {
        if (this.beanManager == null) {
            this.beanManager = Beans.getBeanManager();
        }
        return this.beanManager;
    }

    public CustomBean(Class<Object> beanClass, BeanManager beanManager) {
        this.beanClass = beanClass;
        this.beanManager = beanManager;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        Object instance = this.getInjectionTarget().produce(creationalContext);
        this.getInjectionTarget().inject(instance, creationalContext);
        this.getInjectionTarget().postConstruct(instance);
        return instance;
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
        this.getInjectionTarget().preDestroy(instance);
        this.getInjectionTarget().dispose(instance);
        creationalContext.release();
    }

    public Set<Type> getTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types.add(this.beanClass.getSuperclass());
        types.add((Type)((Object)Object.class));
        return types;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> result = new HashSet<Annotation>();
        result.add((Annotation)new AnnotationLiteral<Default>(){});
        result.add((Annotation)new AnnotationLiteral<Any>(){});
        for (Annotation annotation : this.beanClass.getAnnotations()) {
            if (!annotation.getClass().isAnnotationPresent(Qualifier.class)) continue;
            result.add(annotation);
        }
        return result;
    }

    public Class<? extends Annotation> getScope() {
        Class result = Dependent.class;
        for (Annotation annotation : this.beanClass.getAnnotations()) {
            Class<?> annotationClass = annotation.getClass();
            if (!annotationClass.isAnnotationPresent(Scope.class) && !annotationClass.isAnnotationPresent(NormalScope.class)) continue;
            result = annotationClass;
            break;
        }
        return result;
    }

    public String getName() {
        String result = null;
        if (this.beanClass.isAnnotationPresent(Named.class)) {
            result = this.beanClass.getAnnotation(Named.class).value();
        }
        return result;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : this.beanClass.getAnnotations()) {
            if (!annotation.getClass().isAnnotationPresent(Stereotype.class)) continue;
            result.add(annotation.getClass());
        }
        return result;
    }

    public Class<Object> getBeanClass() {
        return this.beanClass;
    }

    public boolean isAlternative() {
        return this.beanClass.isAnnotationPresent(Alternative.class);
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.getInjectionTarget().getInjectionPoints();
    }
}

