/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.internal.context.CustomContext;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import org.slf4j.Logger;

public class Contexts {
    private static List<CustomContext> activeContexts = Collections.synchronizedList(new ArrayList());
    private static List<CustomContext> inactiveContexts = Collections.synchronizedList(new ArrayList());
    private static Logger logger;
    private static ResourceBundle bundle;

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerProducer.create(Contexts.class);
        }
        return logger;
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceBundleProducer.create("demoiselle-core-bundle");
        }
        return bundle;
    }

    private Contexts() {
    }

    public static synchronized void add(CustomContext context, AfterBeanDiscovery event) {
        Class scope = context.getScope();
        Contexts.getLogger().trace(Contexts.getBundle().getString("custom-context-was-registered", context.getScope().getCanonicalName()));
        if (Contexts.get(scope, activeContexts) != null) {
            inactiveContexts.add(context);
            context.setActive(false);
        } else {
            activeContexts.add(context);
            context.setActive(true);
        }
        if (event != null) {
            event.addContext((Context)context);
        }
    }

    private static CustomContext get(Class<? extends Annotation> scope, List<CustomContext> contexts) {
        CustomContext result = null;
        for (CustomContext context : contexts) {
            if (!scope.equals(context.getScope())) continue;
            result = context;
            break;
        }
        return result;
    }

    public static synchronized void remove(CustomContext context) {
        Contexts.getLogger().trace(Contexts.getBundle().getString("custom-context-was-unregistered", context.getScope().getCanonicalName()));
        if (activeContexts.contains(context)) {
            activeContexts.remove(context);
            context.setActive(false);
            CustomContext inactive = Contexts.get(context.getScope(), inactiveContexts);
            if (inactive != null) {
                activeContexts.add(inactive);
                inactive.setActive(true);
                inactiveContexts.remove(inactive);
            }
        } else if (inactiveContexts.contains(context)) {
            inactiveContexts.remove(context);
        }
    }

    public static synchronized void clear() {
        Iterator<CustomContext> iter = activeContexts.iterator();
        while (iter.hasNext()) {
            CustomContext context = iter.next();
            context.setActive(false);
            iter.remove();
        }
        activeContexts.clear();
        inactiveContexts.clear();
    }

    public static synchronized List<CustomContext> getActiveContexts() {
        return activeContexts;
    }

    public static synchronized List<CustomContext> getInactiveContexts() {
        return inactiveContexts;
    }
}

