/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.internal.context.ContextStore;
import br.gov.frameworkdemoiselle.internal.context.CustomContext;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;

public class ThreadLocalContext
implements CustomContext {
    private final ThreadLocal<ContextStore> threadLocal = new ThreadLocal();
    private boolean active;
    private final Class<? extends Annotation> scope;

    public ThreadLocalContext(Class<? extends Annotation> scope) {
        this(scope, true);
    }

    public ThreadLocalContext(Class<? extends Annotation> scope, boolean active) {
        this.scope = scope;
        this.active = active;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Object instance = null;
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        String id = this.getId(contextual);
        if (this.getStore().contains(id)) {
            instance = this.getStore().get(id);
        } else if (creationalContext != null) {
            instance = contextual.create(creationalContext);
            this.getStore().put(id, instance);
        }
        return (T)instance;
    }

    private <T> String getId(Contextual<T> contextual) {
        Bean bean = (Bean)contextual;
        return bean.getBeanClass().getCanonicalName();
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    private ContextStore getStore() {
        if (this.threadLocal.get() == null) {
            this.threadLocal.set(new ContextStore());
        }
        return this.threadLocal.get();
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }
}

