/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.interceptor;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.exception.ExceptionHandler;
import br.gov.frameworkdemoiselle.internal.bootstrap.CoreBootstrap;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.stereotype.Controller;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Interceptor
@Controller
public class ExceptionHandlerInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle bundle;
    private static Logger logger;
    private final Map<Class<?>, Map<Class<?>, Method>> cache = new HashMap();

    private final boolean handleException(Exception cause, Object target) throws Exception {
        Method handler;
        ExceptionHandlerInterceptor.getLogger().info(ExceptionHandlerInterceptor.getBundle().getString("handling-exception", cause.getClass().getCanonicalName()));
        boolean handled = false;
        Class<?> type = this.getType(target);
        if (!this.isLoaded(type)) {
            this.loadHandlers(type);
        }
        if ((handler = this.getMethod(type, cause)) != null) {
            this.invoke(handler, target, cause);
            handled = true;
        }
        return handled;
    }

    private final Class<?> getType(Object target) {
        Class<?> type = target.getClass();
        CoreBootstrap bootstrap = Beans.getReference(CoreBootstrap.class);
        if (!bootstrap.isAnnotatedType(type)) {
            ExceptionHandlerInterceptor.getLogger().debug(ExceptionHandlerInterceptor.getBundle().getString("proxy-detected", type, type.getSuperclass()));
            type = type.getSuperclass();
        }
        return type;
    }

    private final Method getMethod(Class<?> type, Exception cause) {
        Method handler = null;
        if (this.cache.containsKey(type) && this.cache.get(type).containsKey(cause.getClass())) {
            handler = this.cache.get(type).get(cause.getClass());
        }
        return handler;
    }

    private final void loadHandlers(Class<?> type) {
        Method[] methods;
        HashMap mapHandlers = new HashMap();
        for (Method method : methods = type.getMethods()) {
            if (!method.isAnnotationPresent(ExceptionHandler.class)) continue;
            this.validateHandler(method);
            mapHandlers.put(method.getParameterTypes()[0], method);
        }
        this.cache.put(type, mapHandlers);
    }

    private final void validateHandler(Method method) {
        if (method.getParameterTypes().length != 1) {
            throw new DemoiselleException(ExceptionHandlerInterceptor.getBundle().getString("must-declare-one-single-parameter", method.toGenericString()));
        }
    }

    private final boolean isLoaded(Class<?> type) {
        return this.cache.containsKey(type);
    }

    private final void invoke(Method method, Object object, Exception param) throws Exception {
        boolean accessible = method.isAccessible();
        method.setAccessible(true);
        try {
            method.invoke(object, param);
        }
        catch (InvocationTargetException cause) {
            Throwable targetTrowable = cause.getTargetException();
            if (targetTrowable instanceof Exception) {
                throw (Exception)targetTrowable;
            }
            throw new Exception(targetTrowable);
        }
        method.setAccessible(accessible);
    }

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        Object result;
        block2: {
            Object target = null;
            result = null;
            try {
                target = ic.getTarget();
                result = ic.proceed();
            }
            catch (Exception cause) {
                if (this.handleException(cause, target)) break block2;
                throw cause;
            }
        }
        return result;
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceBundleProducer.create("demoiselle-core-bundle");
        }
        return bundle;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerProducer.create(ExceptionHandlerInterceptor.class);
        }
        return logger;
    }
}

