/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.interceptor;

import br.gov.frameworkdemoiselle.exception.ApplicationException;
import br.gov.frameworkdemoiselle.internal.implementation.TransactionInfo;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.transaction.TransactionContext;
import br.gov.frameworkdemoiselle.transaction.Transactional;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import javax.enterprise.context.ContextNotActiveException;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.slf4j.Logger;

@Interceptor
@Transactional
public class TransactionalInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TransactionContext transactionContext;
    private TransactionInfo transactionInfo;
    private static ResourceBundle bundle;
    private static Logger logger;

    private TransactionContext getTransactionContext() {
        if (this.transactionContext == null) {
            this.transactionContext = Beans.getReference(TransactionContext.class);
        }
        return this.transactionContext;
    }

    private TransactionInfo newTransactionInfo() {
        TransactionInfo instance;
        try {
            instance = Beans.getReference(TransactionInfo.class);
            instance.getCounter();
        }
        catch (ContextNotActiveException cause) {
            instance = new TransactionInfo(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isOwner() {
                    return false;
                }
            };
        }
        return instance;
    }

    private TransactionInfo getTransactionInfo() {
        if (this.transactionInfo == null) {
            this.transactionInfo = this.newTransactionInfo();
        }
        return this.transactionInfo;
    }

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        this.initiate(ic);
        Object result = null;
        try {
            TransactionalInterceptor.getLogger().debug(TransactionalInterceptor.getBundle().getString("transactional-execution", ic.getMethod().toGenericString()));
            result = ic.proceed();
        }
        catch (Exception cause) {
            this.handleException(cause);
            throw cause;
        }
        finally {
            this.complete(ic);
        }
        return result;
    }

    private void initiate(InvocationContext ic) {
        Transaction transaction = this.getTransactionContext().getCurrentTransaction();
        TransactionInfo transactionInfo = this.getTransactionInfo();
        if (!transaction.isActive()) {
            transaction.begin();
            transactionInfo.markAsOwner();
            TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("begin-transaction"));
        }
        transactionInfo.incrementCounter();
    }

    private void handleException(Exception cause) {
        Transaction transaction = this.getTransactionContext().getCurrentTransaction();
        if (!transaction.isMarkedRollback()) {
            boolean rollback = false;
            ApplicationException annotation = cause.getClass().getAnnotation(ApplicationException.class);
            if (annotation == null || annotation.rollback()) {
                rollback = true;
            }
            if (rollback) {
                transaction.setRollbackOnly();
                TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("transaction-marked-rollback", cause.getMessage()));
            }
        }
    }

    private void complete(InvocationContext ic) {
        Transaction transaction = this.getTransactionContext().getCurrentTransaction();
        TransactionInfo transactionInfo = this.getTransactionInfo();
        transactionInfo.decrementCounter();
        if (transactionInfo.getCounter() == 0 && transaction.isActive()) {
            if (transactionInfo.isOwner()) {
                if (transaction.isMarkedRollback()) {
                    transaction.rollback();
                    transactionInfo.clear();
                    TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("transaction-rolledback"));
                } else {
                    transaction.commit();
                    transactionInfo.clear();
                    TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("transaction-commited"));
                }
            }
        } else if (transactionInfo.getCounter() == 0 && !transaction.isActive()) {
            TransactionalInterceptor.getLogger().info(TransactionalInterceptor.getBundle().getString("transaction-already-finalized"));
        }
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = ResourceBundleProducer.create("demoiselle-core-bundle");
        }
        return bundle;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerProducer.create(TransactionalInterceptor.class);
        }
        return logger;
    }
}

