/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.template;

import br.gov.frameworkdemoiselle.internal.implementation.DefaultTransaction;
import br.gov.frameworkdemoiselle.template.Crud;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.transaction.Transactional;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Reflections;
import java.util.List;
import java.util.ListIterator;

public class DelegateCrud<T, I, C extends Crud<T, I>>
implements Crud<T, I> {
    private static final long serialVersionUID = 1L;
    private Class<C> delegateClass;
    private transient C delegate;

    @Override
    public void delete(I id) {
        if (this.isRunningTransactionalOperations()) {
            this.transactionalDelete(id);
        } else {
            this.nonTransactionalDelete(id);
        }
    }

    @Transactional
    private void transactionalDelete(I id) {
        this.nonTransactionalDelete(id);
    }

    private void nonTransactionalDelete(I id) {
        this.getDelegate().delete(id);
    }

    @Override
    public void delete(List<I> ids) {
        if (this.isRunningTransactionalOperations()) {
            this.transactionalDelete(ids);
        } else {
            this.nonTransactionalDelete(ids);
        }
    }

    @Transactional
    private void transactionalDelete(List<I> ids) {
        this.nonTransactionalDelete(ids);
    }

    private void nonTransactionalDelete(List<I> ids) {
        ListIterator<I> iter = ids.listIterator();
        while (iter.hasNext()) {
            this.delete(iter.next());
        }
    }

    @Override
    public List<T> findAll() {
        return this.getDelegate().findAll();
    }

    protected C getDelegate() {
        if (this.delegate == null) {
            this.delegate = (Crud)Beans.getReference(this.getDelegateClass());
        }
        return this.delegate;
    }

    protected Class<C> getDelegateClass() {
        if (this.delegateClass == null) {
            this.delegateClass = Reflections.getGenericTypeArgument(this.getClass(), 2);
        }
        return this.delegateClass;
    }

    @Override
    public void insert(T bean) {
        if (this.isRunningTransactionalOperations()) {
            this.transactionalInsert(bean);
        } else {
            this.nonTransactionalInsert(bean);
        }
    }

    @Transactional
    private void transactionalInsert(T bean) {
        this.nonTransactionalInsert(bean);
    }

    private void nonTransactionalInsert(T bean) {
        this.getDelegate().insert(bean);
    }

    @Override
    public T load(I id) {
        return this.getDelegate().load(id);
    }

    @Override
    public void update(T bean) {
        if (this.isRunningTransactionalOperations()) {
            this.transactionalUpdate(bean);
        } else {
            this.nonTransactionalUpdate(bean);
        }
    }

    @Transactional
    private void transactionalUpdate(T bean) {
        this.nonTransactionalUpdate(bean);
    }

    private void nonTransactionalUpdate(T bean) {
        this.getDelegate().update(bean);
    }

    private boolean isRunningTransactionalOperations() {
        return !(Beans.getReference(Transaction.class) instanceof DefaultTransaction);
    }
}

