/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.util.Exceptions;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class Reflections {
    private Reflections() {
    }

    public static <T> Class<T> getGenericTypeArgument(Class<?> clazz, int idx) {
        ParameterizedType paramType;
        Type type = clazz.getGenericSuperclass();
        try {
            paramType = (ParameterizedType)type;
        }
        catch (ClassCastException cause) {
            paramType = (ParameterizedType)((Class)type).getGenericSuperclass();
        }
        return (Class)paramType.getActualTypeArguments()[idx];
    }

    public static <T> Class<T> getGenericTypeArgument(Field field, int idx) {
        Type type = field.getGenericType();
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[idx];
    }

    public static <T> Class<T> getGenericTypeArgument(Member member, int idx) {
        Class<T> result = null;
        if (member instanceof Field) {
            result = Reflections.getGenericTypeArgument((Field)member, idx);
        } else if (member instanceof Method) {
            result = Reflections.getGenericTypeArgument((Method)member, idx);
        }
        return result;
    }

    public static <T> Class<T> getGenericTypeArgument(Method method, int pos) {
        return (Class)method.getGenericParameterTypes()[pos];
    }

    public static Object getFieldValue(Field field, Object object) {
        Object result = null;
        try {
            boolean acessible = field.isAccessible();
            field.setAccessible(true);
            result = field.get(object);
            field.setAccessible(acessible);
        }
        catch (Exception e) {
            Exceptions.handleToRuntimeException(e);
        }
        return result;
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        try {
            boolean acessible = field.isAccessible();
            field.setAccessible(true);
            field.set(object, value);
            field.setAccessible(acessible);
        }
        catch (Exception e) {
            Exceptions.handleToRuntimeException(e);
        }
    }

    public static Field[] getNonStaticDeclaredFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (type != null) {
            for (Field field : type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getType().equals(type.getDeclaringClass())) continue;
                fields.add(field);
            }
        }
        return fields.toArray(new Field[0]);
    }

    public static <T> T instantiate(Class<T> clasz) {
        T object = null;
        try {
            object = clasz.newInstance();
        }
        catch (InstantiationException e) {
            Exceptions.handleToRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.handleToRuntimeException(e);
        }
        return object;
    }

    public static boolean isOfType(Class<?> clazz, Class<?> type) {
        return type.isAssignableFrom(clazz) && clazz != type;
    }
}

