/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.util.Strings;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;

public class ResourceBundle
extends java.util.ResourceBundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String baseName;
    private transient java.util.ResourceBundle delegate;
    private final Locale locale;

    private java.util.ResourceBundle getDelegate() {
        if (this.delegate == null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                this.delegate = ResourceBundle.getBundle(this.baseName, this.locale, classLoader);
            }
            catch (MissingResourceException mre) {
                this.delegate = ResourceBundle.getBundle(this.baseName, this.locale);
            }
        }
        return this.delegate;
    }

    public ResourceBundle(String baseName, Locale locale) {
        this.baseName = baseName;
        this.locale = locale;
    }

    @Override
    public boolean containsKey(String key) {
        return this.getDelegate().containsKey(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.getDelegate().getKeys();
    }

    @Override
    public Locale getLocale() {
        return this.getDelegate().getLocale();
    }

    @Override
    public Set<String> keySet() {
        return this.getDelegate().keySet();
    }

    public String getString(String key, Object ... params) {
        return Strings.getString(this.getString(key), params);
    }

    @Override
    protected Object handleGetObject(String key) {
        Object result;
        try {
            Method method = this.getDelegate().getClass().getMethod("handleGetObject", String.class);
            method.setAccessible(true);
            result = method.invoke((Object)this.delegate, key);
            method.setAccessible(false);
        }
        catch (Exception cause) {
            throw new RuntimeException(cause);
        }
        return result;
    }
}

