/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.util.Locale;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;

public class CoreBootstrap
implements Extension {
    private Logger logger;
    private transient ResourceBundle bundle;

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerProducer.create("br.gov.frameworkdemoiselle.lifecycle");
        }
        return this.logger;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = new ResourceBundle("demoiselle-core-bundle", Locale.getDefault());
        }
        return this.bundle;
    }

    public void engineOn(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        this.getLogger().info(this.getBundle().getString("engine-on"));
        Beans.setBeanManager(beanManager);
        this.getLogger().finer(this.getBundle().getString("setting-up-bean-manager", Beans.class.getCanonicalName()));
    }

    public void takeOff(@Observes AfterDeploymentValidation event) {
        this.getLogger().fine(this.getBundle().getString("taking-off"));
    }

    public void engineOff(@Observes BeforeShutdown event) {
        this.getLogger().fine(this.getBundle().getString("engine-off"));
    }
}

