/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.bootstrap;

import br.gov.frameworkdemoiselle.context.CustomContext;
import br.gov.frameworkdemoiselle.context.StaticContext;
import br.gov.frameworkdemoiselle.internal.context.ContextualStore;
import br.gov.frameworkdemoiselle.internal.context.StaticContextImpl;
import br.gov.frameworkdemoiselle.internal.context.TemporaryConversationContextImpl;
import br.gov.frameworkdemoiselle.internal.context.TemporaryRequestContextImpl;
import br.gov.frameworkdemoiselle.internal.context.TemporarySessionContextImpl;
import br.gov.frameworkdemoiselle.internal.context.TemporaryViewContextImpl;
import br.gov.frameworkdemoiselle.lifecycle.AfterShutdownProccess;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

public class CustomContextBootstrap
implements Extension {
    private List<CustomContext> contexts;
    private final ContextualStore contextualStore = new ContextualStore();

    public <T extends CustomContext> void vetoCustomContexts(@Observes ProcessAnnotatedType<T> event) {
        if (CustomContext.class.isAssignableFrom(event.getAnnotatedType().getJavaClass())) {
            event.veto();
        }
    }

    public void initializeContexts(@Observes AfterBeanDiscovery event) {
        if (this.contexts == null || this.contexts.isEmpty()) {
            this.contexts = new ArrayList<CustomContext>();
            TemporaryRequestContextImpl temporaryRequestContextImpl = new TemporaryRequestContextImpl();
            this.contexts.add(temporaryRequestContextImpl);
            TemporarySessionContextImpl temporarySessionContextImpl = new TemporarySessionContextImpl();
            this.contexts.add(temporarySessionContextImpl);
            StaticContextImpl staticContextImpl = new StaticContextImpl();
            this.contexts.add(staticContextImpl);
            TemporaryViewContextImpl temporaryViewContextImpl = new TemporaryViewContextImpl();
            this.contexts.add(temporaryViewContextImpl);
            TemporaryConversationContextImpl temporaryConversationContextImpl = new TemporaryConversationContextImpl();
            this.contexts.add(temporaryConversationContextImpl);
            for (CustomContext c : this.contexts) {
                event.addContext((Context)c);
            }
        }
        for (CustomContext customContext : this.contexts) {
            if (!(customContext instanceof StaticContext)) continue;
            StaticContext staticContext = (StaticContext)customContext;
            staticContext.activate();
            break;
        }
    }

    public void terminateContexts(@Observes AfterShutdownProccess event) {
        if (this.contexts != null) {
            for (CustomContext context : this.contexts) {
                context.deactivate();
            }
            this.contexts.clear();
            this.contextualStore.clear();
        }
    }

    public List<CustomContext> getCustomContexts() {
        return this.contexts;
    }

    public ContextualStore getContextualStore() {
        return this.contextualStore;
    }
}

