/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.CreationalContext;

public class BeanStore
implements Iterable<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private ConcurrentMap<String, Object> instanceCache = new ConcurrentHashMap<String, Object>();
    private ConcurrentMap<String, CreationalContext> creationalCache = new ConcurrentHashMap<String, CreationalContext>();

    public <T> void put(String id, T instance, CreationalContext<T> creationalContext) {
        this.instanceCache.putIfAbsent(id, instance);
        this.creationalCache.putIfAbsent(id, creationalContext);
    }

    public Object getInstance(String id) {
        return this.instanceCache.get(id);
    }

    public CreationalContext getCreationalContext(String id) {
        return (CreationalContext)this.creationalCache.get(id);
    }

    public void clear() {
        this.instanceCache.clear();
        this.creationalCache.clear();
    }

    public boolean contains(String id) {
        return this.instanceCache.containsKey(id);
    }

    @Override
    public Iterator<String> iterator() {
        return this.instanceCache.keySet().iterator();
    }
}

