/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.configuration.SecurityConfig;
import br.gov.frameworkdemoiselle.security.AfterLoginSuccessful;
import br.gov.frameworkdemoiselle.security.AfterLogoutSuccessful;
import br.gov.frameworkdemoiselle.security.AuthenticationException;
import br.gov.frameworkdemoiselle.security.Authenticator;
import br.gov.frameworkdemoiselle.security.AuthorizationException;
import br.gov.frameworkdemoiselle.security.Authorizer;
import br.gov.frameworkdemoiselle.security.NotLoggedInException;
import br.gov.frameworkdemoiselle.security.SecurityContext;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import br.gov.frameworkdemoiselle.util.StrategyQualifier;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.Principal;
import javax.inject.Named;

@Named(value="securityContext")
public class SecurityContextImpl
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    private transient ResourceBundle bundle;
    private Authenticator authenticator;
    private Authorizer authorizer;

    private Authenticator getAuthenticator() {
        if (this.authenticator == null) {
            Class<? extends Authenticator> type = this.getConfig().getAuthenticatorClass();
            this.authenticator = type != null ? Beans.getReference(type) : Beans.getReference(Authenticator.class, new StrategyQualifier());
        }
        return this.authenticator;
    }

    private Authorizer getAuthorizer() {
        if (this.authorizer == null) {
            Class<? extends Authorizer> type = this.getConfig().getAuthorizerClass();
            this.authorizer = type != null ? Beans.getReference(type) : Beans.getReference(Authorizer.class, new StrategyQualifier());
        }
        return this.authorizer;
    }

    @Override
    public boolean hasPermission(String resource, String operation) {
        boolean result = true;
        if (this.getConfig().isEnabled()) {
            this.checkLoggedIn();
            try {
                result = this.getAuthorizer().hasPermission(resource, operation);
            }
            catch (DemoiselleException cause) {
                throw cause;
            }
            catch (Exception cause) {
                throw new AuthorizationException(cause);
            }
        }
        return result;
    }

    @Override
    public boolean hasRole(String role) {
        boolean result = true;
        if (this.getConfig().isEnabled()) {
            this.checkLoggedIn();
            try {
                result = this.getAuthorizer().hasRole(role);
            }
            catch (DemoiselleException cause) {
                throw cause;
            }
            catch (Exception cause) {
                throw new AuthorizationException(cause);
            }
        }
        return result;
    }

    @Override
    public boolean isLoggedIn() {
        boolean result = true;
        if (this.getConfig().isEnabled()) {
            result = this.getUser() != null;
        }
        return result;
    }

    @Override
    public void login() {
        if (this.getConfig().isEnabled()) {
            try {
                this.getAuthenticator().authenticate();
            }
            catch (DemoiselleException cause) {
                throw cause;
            }
            catch (Exception cause) {
                throw new AuthenticationException(cause);
            }
            Beans.getBeanManager().fireEvent((Object)new AfterLoginSuccessful(){
                private static final long serialVersionUID = 1L;
            }, new Annotation[0]);
        }
    }

    @Override
    public void logout() throws NotLoggedInException {
        if (this.getConfig().isEnabled()) {
            this.checkLoggedIn();
            try {
                this.getAuthenticator().unauthenticate();
            }
            catch (DemoiselleException cause) {
                throw cause;
            }
            catch (Exception cause) {
                throw new AuthenticationException(cause);
            }
            Beans.getBeanManager().fireEvent((Object)new AfterLogoutSuccessful(){
                private static final long serialVersionUID = 1L;
            }, new Annotation[0]);
        }
    }

    @Override
    public Principal getUser() {
        Principal user = this.getAuthenticator().getUser();
        if (!this.getConfig().isEnabled() && user == null) {
            user = new EmptyUser();
        }
        return user;
    }

    private SecurityConfig getConfig() {
        return Beans.getReference(SecurityConfig.class);
    }

    @Override
    public void checkLoggedIn() throws NotLoggedInException {
        if (!this.isLoggedIn()) {
            throw new NotLoggedInException(this.getBundle().getString("user-not-authenticated"));
        }
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return this.bundle;
    }

    private static class EmptyUser
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EmptyUser() {
        }

        @Override
        public String getName() {
            return "demoiselle";
        }
    }
}

