/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.message;

import br.gov.frameworkdemoiselle.message.Message;
import br.gov.frameworkdemoiselle.message.SeverityType;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import br.gov.frameworkdemoiselle.util.Strings;

public class DefaultMessage
implements Message {
    private final String originalText;
    private String parsedText;
    private final SeverityType severity;
    private final Object[] params;
    private final ResourceBundle bundle;
    public static final SeverityType DEFAULT_SEVERITY = SeverityType.INFO;

    public DefaultMessage(String text, SeverityType severity, Object ... params) {
        this.originalText = text;
        this.severity = severity == null ? DEFAULT_SEVERITY : severity;
        this.params = params;
        this.bundle = Beans.getReference(ResourceBundle.class);
        this.initParsedText();
    }

    public DefaultMessage(String text, Object ... params) {
        this(text, null, params);
    }

    private void initParsedText() {
        if (Strings.isResourceBundleKeyFormat(this.originalText)) {
            this.parsedText = this.bundle.getString(Strings.removeBraces(this.originalText));
        } else if (this.originalText != null) {
            this.parsedText = new String(this.originalText);
        }
        this.parsedText = Strings.getString(this.parsedText, this.params);
    }

    @Override
    public String getText() {
        return this.parsedText;
    }

    @Override
    public SeverityType getSeverity() {
        return this.severity;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parsedText == null ? 0 : this.parsedText.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultMessage other = (DefaultMessage)obj;
        if (this.parsedText == null ? other.parsedText != null : !this.parsedText.equals(other.parsedText)) {
            return false;
        }
        return this.severity == other.severity;
    }
}

