/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.template;

import br.gov.frameworkdemoiselle.template.Crud;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Reflections;
import java.util.List;
import java.util.ListIterator;

public class DelegateCrud<T, I, C extends Crud<T, I>>
implements Crud<T, I> {
    private static final long serialVersionUID = 1L;
    private Class<C> delegateClass;
    private transient C delegate;

    @Override
    public void delete(I id) {
        this.getDelegate().delete(id);
    }

    @Override
    public void delete(List<I> ids) {
        ListIterator<I> iter = ids.listIterator();
        while (iter.hasNext()) {
            this.delete(iter.next());
        }
    }

    @Override
    public List<T> findAll() {
        return this.getDelegate().findAll();
    }

    protected C getDelegate() {
        if (this.delegate == null) {
            this.delegate = (Crud)Beans.getReference(this.getDelegateClass());
        }
        return this.delegate;
    }

    protected Class<C> getDelegateClass() {
        if (this.delegateClass == null) {
            this.delegateClass = Reflections.getGenericTypeArgument(this.getClass(), 2);
        }
        return this.delegateClass;
    }

    @Override
    public T insert(T bean) {
        return this.getDelegate().insert(bean);
    }

    @Override
    public T load(I id) {
        return this.getDelegate().load(id);
    }

    @Override
    public T update(T bean) {
        return this.getDelegate().update(bean);
    }
}

