/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.util.Exceptions;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Reflections {
    protected Reflections() {
        throw new UnsupportedOperationException();
    }

    public static <T> Class<T> getGenericTypeArgument(Class<?> clazz, int idx) {
        ParameterizedType paramType;
        Type type = clazz.getGenericSuperclass();
        try {
            paramType = (ParameterizedType)type;
        }
        catch (ClassCastException cause) {
            return Reflections.getGenericTypeArgument((Class)type, idx);
        }
        return (Class)paramType.getActualTypeArguments()[idx];
    }

    public static <T> Class<T> getGenericTypeArgument(Field field, int idx) {
        Type type = field.getGenericType();
        ParameterizedType paramType = (ParameterizedType)type;
        return (Class)paramType.getActualTypeArguments()[idx];
    }

    public static <T> Class<T> getGenericTypeArgument(Member member, int idx) {
        Class<T> result = null;
        if (member instanceof Field) {
            result = Reflections.getGenericTypeArgument((Field)member, idx);
        } else if (member instanceof Method) {
            result = Reflections.getGenericTypeArgument((Method)member, idx);
        }
        return result;
    }

    public static <T> Class<T> getGenericTypeArgument(Method method, int pos) {
        return (Class)method.getGenericParameterTypes()[pos];
    }

    public static <T> T getFieldValue(Field field, Object object) {
        Object result = null;
        try {
            boolean acessible = field.isAccessible();
            field.setAccessible(true);
            result = field.get(object);
            field.setAccessible(acessible);
        }
        catch (Exception e) {
            Exceptions.handleToRuntimeException(e);
        }
        return (T)result;
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        try {
            boolean acessible = field.isAccessible();
            field.setAccessible(true);
            field.set(object, value);
            field.setAccessible(acessible);
        }
        catch (Exception e) {
            Exceptions.handleToRuntimeException(e);
        }
    }

    public static Field[] getNonStaticDeclaredFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (type != null) {
            Field[] fieldArray = type.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!Modifier.isStatic(field.getModifiers()) && !field.getType().equals(type.getDeclaringClass())) {
                    fields.add(field);
                }
                ++n2;
            }
        }
        return fields.toArray(new Field[0]);
    }

    public static List<Field> getNonStaticFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (type != null) {
            Class<?> currentType = type;
            while (currentType != null && !"java.lang.Object".equals(currentType.getCanonicalName())) {
                fields.addAll(Arrays.asList(Reflections.getNonStaticDeclaredFields(currentType)));
                currentType = currentType.getSuperclass();
            }
        }
        return fields;
    }

    public static <T> T instantiate(Class<T> clazz) {
        T object = null;
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e) {
            Exceptions.handleToRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.handleToRuntimeException(e);
        }
        return object;
    }

    public static boolean isOfType(Class<?> clazz, Class<?> type) {
        return type.isAssignableFrom(clazz) && clazz != type;
    }

    public static ClassLoader getClassLoaderForClass(String canonicalName) {
        return Reflections.getClassLoaderForResource(String.valueOf(canonicalName.replaceAll("\\.", "/")) + ".class");
    }

    public static ClassLoader getClassLoaderForResource(String resource) {
        String stripped = resource.charAt(0) == '/' ? resource.substring(1) : resource;
        URL url = null;
        ClassLoader result = Thread.currentThread().getContextClassLoader();
        if (result != null) {
            url = result.getResource(stripped);
        }
        if (url == null) {
            result = Reflections.class.getClassLoader();
            url = Reflections.class.getClassLoader().getResource(stripped);
        }
        if (url == null) {
            result = null;
        }
        return result;
    }

    public static URL getResourceAsURL(String resource) {
        ClassLoader classLoader = Reflections.getClassLoaderForResource(resource);
        return classLoader != null ? classLoader.getResource(resource) : null;
    }

    public static InputStream getResourceAsStream(String resource) {
        ClassLoader classLoader = Reflections.getClassLoaderForResource(resource);
        return classLoader != null ? classLoader.getResourceAsStream(resource) : null;
    }

    public static <T> Class<T> forName(String className) throws ClassNotFoundException {
        ClassLoader classLoader = Reflections.getClassLoaderForClass(className);
        return Class.forName(className, true, classLoader);
    }
}

