/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.annotation.Ignore;
import br.gov.frameworkdemoiselle.util.Reflections;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Strings {
    private Strings() {
    }

    public static boolean isResourceBundleKeyFormat(String key) {
        return Pattern.matches("^\\{(.+)\\}$", key == null ? "" : key);
    }

    public static String removeChars(String string, char ... chars) {
        String result = string;
        if (result != null) {
            char[] cArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                result = result.replace(String.valueOf(ch), "");
                ++n2;
            }
        }
        return result;
    }

    public static String join(String separator, String ... strings) {
        StringBuffer result = new StringBuffer();
        if (strings != null) {
            int i = 0;
            while (i < strings.length) {
                if (i != 0 && separator != null) {
                    result.append(separator);
                }
                if (strings[i] != null) {
                    result.append(strings[i]);
                }
                ++i;
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    public static String insertZeros(String string, int howMuchZeros) {
        StringBuffer result = new StringBuffer((string == null ? "" : string).trim());
        int difference = howMuchZeros - result.toString().length();
        int j = 0;
        while (j < difference) {
            result.insert(0, '0');
            ++j;
        }
        return result.toString();
    }

    public static String getString(String string, Object ... params) {
        String result = null;
        if (string != null) {
            result = new String(string);
        }
        if (params != null && string != null) {
            int i = 0;
            while (i < params.length) {
                if (params[i] != null) {
                    result = result.replaceAll("\\{" + i + "\\}", Matcher.quoteReplacement(params[i].toString()));
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static String toString(Object object) {
        StringBuffer result = new StringBuffer();
        if (object != null) {
            result.append(object.getClass().getSimpleName());
            result.append(" [");
            boolean first = true;
            Field[] fieldArray = Reflections.getNonStaticDeclaredFields(object.getClass());
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!field.isAnnotationPresent(Ignore.class)) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(", ");
                    }
                    result.append(field.getName());
                    result.append('=');
                    Object fieldValue = Reflections.getFieldValue(field, object);
                    result.append((Object)(fieldValue != null && fieldValue.getClass().isArray() ? Arrays.toString((Object[])fieldValue) : fieldValue));
                }
                ++n2;
            }
            result.append(']');
        }
        return result.toString();
    }

    public static String camelCaseToSymbolSeparated(String string, String symbol) {
        if (symbol == null) {
            symbol = "";
        }
        return string == null ? null : string.replaceAll("\\B([A-Z])", String.valueOf(symbol) + "$1").toLowerCase();
    }

    public static String firstToUpper(String string) {
        String result = string;
        if (!Strings.isEmpty(string)) {
            result = String.valueOf(string.toUpperCase().charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
        }
        return result;
    }

    public static String removeBraces(String string) {
        String result = string;
        if (Strings.isResourceBundleKeyFormat(string)) {
            result = string.substring(1, string.length() - 1);
        }
        return result;
    }

    public static String insertBraces(String string) {
        String result = string;
        if (!Strings.isEmpty(string)) {
            result = "{" + string + "}";
        }
        return result;
    }

    public static String parse(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        if (inputStream != null) {
            try (BufferedReader reader = null;){
                String line;
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }
}

