/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.EntityManagerConfig;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerFactoryProducer;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Logger;

public class Persistences {
    private transient ResourceBundle bundle;
    private transient Logger logger;

    protected String getFromProperties(EntityManagerConfig config) {
        String persistenceUnit = config.getDefaultPersistenceUnitName();
        if (persistenceUnit != null) {
            this.getLogger().fine(this.getBundle().getString("getting-persistence-unit-from-properties", new Object[]{"demoiselle"}));
        }
        return persistenceUnit;
    }

    protected String getFromXML() {
        EntityManagerFactoryProducer factory = (EntityManagerFactoryProducer)Beans.getReference(EntityManagerFactoryProducer.class);
        Set<String> persistenceUnits = factory.getCache().keySet();
        if (persistenceUnits.size() > 1) {
            throw new DemoiselleException(this.getBundle().getString("more-than-one-persistence-unit-defined", new Object[]{Name.class.getSimpleName()}));
        }
        return persistenceUnits.iterator().next();
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-jpa-bundle")});
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = (Logger)Beans.getReference(Logger.class, (Annotation[])new Annotation[]{new NameQualifier("br.gov.frameworkdemoiselle.util")});
        }
        return this.logger;
    }
}

