/*
 * Decompiled with CFR 0.152.
 */
package ca.szc.configparser;

import ca.szc.configparser.StringUtil;
import ca.szc.configparser.exceptions.DuplicateOptionError;
import ca.szc.configparser.exceptions.DuplicateSectionError;
import ca.szc.configparser.exceptions.IniParserException;
import ca.szc.configparser.exceptions.InterpolationDepthError;
import ca.szc.configparser.exceptions.InterpolationMissingOptionError;
import ca.szc.configparser.exceptions.InterpolationSyntaxError;
import ca.szc.configparser.exceptions.InvalidLine;
import ca.szc.configparser.exceptions.MissingSectionHeaderError;
import ca.szc.configparser.exceptions.NoOptionError;
import ca.szc.configparser.exceptions.NoSectionError;
import ca.szc.configparser.exceptions.ParsingError;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Ini {
    private static final Pattern nonWhitespacePattern = Pattern.compile("\\S");
    private static final Pattern sectionPattern = Pattern.compile(Ini.templateSectionPattern());
    private static final Pattern interpolationPattern = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final int MAX_INTERPOLATION_DEPTH = 10;
    private boolean allowDuplicates = false;
    private boolean allowInterpolation = true;
    private boolean allowNoValue = false;
    private List<String> commentPrefixes;
    private List<String> delimiters;
    private boolean emptyLinesInValues;
    private List<String> inlineCommentPrefixes;
    private Map<String, Integer> lineNumberMap;
    private Pattern optionPattern;
    List<ParsingError> parsingErrors = new LinkedList<ParsingError>();
    private final Map<String, Map<String, String>> sections;
    private boolean spaceAroundDelimiters;
    private Map<String, String> rawValues;

    private static String templateOptionPattern(List<String> delimiters, boolean allowNoValue) {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (String delimiter : delimiters) {
            sb.append(prefix);
            prefix = "|";
            sb.append(Pattern.quote(delimiter));
        }
        String delimiterRegEx = sb.toString();
        sb = new StringBuilder();
        sb.append("(?<option>.*?)");
        sb.append("\\s*");
        if (allowNoValue) {
            sb.append("(?:");
        }
        sb.append("(?<vi>");
        sb.append(delimiterRegEx);
        sb.append(")");
        sb.append("\\s*");
        sb.append("(?<value>.*)");
        if (allowNoValue) {
            sb.append(")?");
        }
        sb.append("$");
        return sb.toString();
    }

    private static String templateSectionPattern() {
        StringBuilder sb = new StringBuilder();
        sb.append("\\[");
        sb.append("(?<header>[^]]+)");
        sb.append("\\]");
        return sb.toString();
    }

    public Ini() {
        this.commentPrefixes = new ArrayList<String>(2);
        this.commentPrefixes.add("#");
        this.commentPrefixes.add(";");
        this.delimiters = new ArrayList<String>(2);
        this.delimiters.add("=");
        this.delimiters.add(":");
        this.emptyLinesInValues = true;
        this.inlineCommentPrefixes = new ArrayList<String>(0);
        this.lineNumberMap = new HashMap<String, Integer>();
        this.compileOptionPattern();
        this.sections = new LinkedHashMap<String, Map<String, String>>();
        this.spaceAroundDelimiters = true;
        this.rawValues = new HashMap<String, String>();
    }

    private void compileOptionPattern() {
        this.optionPattern = Pattern.compile(Ini.templateOptionPattern(this.delimiters, this.allowNoValue));
    }

    public List<String> getCommentPrefixes() {
        return this.commentPrefixes;
    }

    public List<String> getDelimiters() {
        return this.delimiters;
    }

    public List<String> getInlineCommentPrefixes() {
        return this.inlineCommentPrefixes;
    }

    public Map<String, Map<String, String>> getSections() {
        return this.sections;
    }

    public String getValue(String sectionName, String optionName) throws NoSectionError, NoOptionError {
        Map<String, String> section = this.sections.get(sectionName);
        if (section == null) {
            throw new NoSectionError(sectionName);
        }
        if (!section.containsKey(optionName.toLowerCase())) {
            throw new NoOptionError(sectionName, optionName);
        }
        return section.get(optionName.toLowerCase());
    }

    public String getValue(String sectionName, String optionName, String fallback) throws NoSectionError, NoOptionError {
        String value;
        try {
            value = this.getValue(sectionName, optionName);
        }
        catch (NoOptionError ex) {
            if (fallback == null) {
                throw ex;
            }
            return fallback;
        }
        return value;
    }

    private void interpolate() throws IniParserException {
        for (String sectionName : this.sections.keySet()) {
            Map<String, String> options = this.sections.get(sectionName);
            for (String optionName : options.keySet()) {
                String rawValue;
                ArrayList<String> L;
                ParsingError pe = this.interpolate(sectionName, optionName, L = new ArrayList<String>(), rawValue = options.get(optionName), 1);
                if (pe == null) {
                    StringBuffer sb = new StringBuffer();
                    for (String component : L) {
                        sb.append(component);
                    }
                    options.put(optionName, sb.toString());
                    this.rawValues.put(sectionName + ":" + optionName.toLowerCase(), rawValue);
                    continue;
                }
                this.parsingErrors.add(pe);
            }
        }
    }

    private ParsingError interpolate(String section, String option, List<String> accum, String rest, int depth) {
        String rawval = "";
        int lineNo = this.lineNumberMap.get(section + ":" + option);
        try {
            rawval = this.getValue(section, option, rest);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (depth > 10) {
            return new InterpolationDepthError(lineNo, option, section, rawval);
        }
        while (rest != null && rest.length() > 0) {
            char c;
            int p = rest.indexOf(36);
            if (p < 0) {
                accum.add(rest);
                return null;
            }
            if (p > 0) {
                accum.add(rest.substring(0, p));
                rest = rest.substring(p);
            }
            if ((c = rest.charAt(1)) == '$') {
                accum.add("" + c);
                rest = rest.substring(2);
                continue;
            }
            if (c == '{') {
                String value;
                String opt;
                String sect;
                block14: {
                    Matcher m = interpolationPattern.matcher(rest);
                    if (!m.find()) {
                        return new InterpolationSyntaxError(lineNo, option, section, "bad interpolation variable reference " + rest);
                    }
                    String[] path = m.group(1).split(":");
                    rest = rest.substring(m.end());
                    sect = section;
                    opt = option;
                    try {
                        if (path.length == 1) {
                            opt = path[0];
                            value = this.getValue(section, opt);
                            break block14;
                        }
                        if (path.length == 2) {
                            sect = path[0];
                            opt = path[1];
                            value = this.getValue(sect, opt);
                            break block14;
                        }
                        return new InterpolationSyntaxError(lineNo, option, section, "More that one ':' found: " + rest);
                    }
                    catch (Exception ex) {
                        return new InterpolationMissingOptionError(lineNo, option, section, rawval, m.group(1));
                    }
                }
                if (value.indexOf("$") > 0) {
                    this.interpolate(sect, opt, accum, value, depth + 1);
                    continue;
                }
                accum.add(value);
                continue;
            }
            return new InterpolationSyntaxError(lineNo, option, section, "'$' must be followed by '$' or '{', found: " + rest);
        }
        return null;
    }

    public boolean isAllowDuplicates() {
        return this.allowDuplicates;
    }

    public boolean isAllowInterpolation() {
        return this.allowInterpolation;
    }

    public boolean isAllowNoValue() {
        return this.allowNoValue;
    }

    public boolean isEmptyLinesInValues() {
        return this.emptyLinesInValues;
    }

    public boolean isSpaceAroundDelimiters() {
        return this.spaceAroundDelimiters;
    }

    public Ini read(BufferedReader reader) throws IOException, IniParserException {
        LinkedHashMap unjoinedSections = new LinkedHashMap();
        Map currSection = null;
        String currSectionName = null;
        String currOptionName = null;
        int indentLevel = 0;
        String line = null;
        int lineNo = 0;
        while ((line = reader.readLine()) != null) {
            ++lineNo;
            int commentStart = -1;
            if (this.inlineCommentPrefixes.size() > 0) {
                int earliestIndex = Integer.MAX_VALUE;
                for (String prefix : this.inlineCommentPrefixes) {
                    int index = line.indexOf(prefix);
                    if (index == 0) {
                        earliestIndex = 0;
                        break;
                    }
                    if (index <= 0 || !Character.isWhitespace(line.charAt(index - 1))) continue;
                    earliestIndex = Math.min(earliestIndex, index);
                }
                commentStart = earliestIndex;
            }
            if (commentStart != 0) {
                for (String prefix : this.commentPrefixes) {
                    if (!StringUtil.strip(line).startsWith(prefix)) continue;
                    commentStart = 0;
                    break;
                }
            }
            String value = commentStart != -1 ? line.substring(0, commentStart) : line;
            if ((value = StringUtil.strip(value)).isEmpty()) {
                if (this.emptyLinesInValues) {
                    if (commentStart != -1 || currSection == null || currOptionName == null || !currSection.containsKey(currOptionName)) continue;
                    ((List)currSection.get(currOptionName)).add("");
                    continue;
                }
                indentLevel = Integer.MAX_VALUE;
                continue;
            }
            Matcher nonWhitespaceMatcher = nonWhitespacePattern.matcher(line);
            int firstNonWhitespace = -1;
            if (nonWhitespaceMatcher.find()) {
                firstNonWhitespace = nonWhitespaceMatcher.start();
            }
            int currIndentLevel = Math.max(firstNonWhitespace, 0);
            if (currSection != null && currOptionName != null && currIndentLevel > indentLevel) {
                ((List)currSection.get(currOptionName)).add(value);
                continue;
            }
            indentLevel = currIndentLevel;
            Matcher sectionMatcher = sectionPattern.matcher(value);
            if (sectionMatcher.matches()) {
                currSectionName = sectionMatcher.group("header");
                if (unjoinedSections.containsKey(currSectionName)) {
                    if (!this.allowDuplicates) {
                        this.parsingErrors.add(new DuplicateSectionError(lineNo, currSectionName));
                        currSectionName = null;
                        currSection = null;
                    } else {
                        currSection = (Map)unjoinedSections.get(currSectionName);
                    }
                } else {
                    currSection = new LinkedHashMap();
                    unjoinedSections.put(currSectionName, currSection);
                }
                currOptionName = null;
                continue;
            }
            if (currSection == null) {
                this.parsingErrors.add(new MissingSectionHeaderError(lineNo, line));
                continue;
            }
            Matcher optionMatcher = this.optionPattern.matcher(value);
            if (optionMatcher.matches()) {
                currOptionName = optionMatcher.group("option");
                String optionValue = optionMatcher.group("value");
                if (currOptionName == null || currOptionName.length() == 0) {
                    this.parsingErrors.add(new InvalidLine(lineNo, line));
                }
                currOptionName = StringUtil.rstrip(currOptionName).toLowerCase();
                if (!this.allowDuplicates && ((Map)unjoinedSections.get(currSectionName)).containsKey(currOptionName)) {
                    this.parsingErrors.add(new DuplicateOptionError(lineNo, currSectionName, currOptionName));
                    continue;
                }
                LinkedList<String> valueList = new LinkedList<String>();
                if (optionValue != null) {
                    optionValue = StringUtil.rstrip(optionValue);
                    valueList.add(optionValue);
                }
                currSection.put(currOptionName, valueList);
                this.lineNumberMap.put(currSectionName + ":" + currOptionName, lineNo);
                continue;
            }
            this.parsingErrors.add(new InvalidLine(lineNo, line));
        }
        if (this.parsingErrors.size() > 0) {
            throw new IniParserException(this.parsingErrors);
        }
        for (Map.Entry unjoinedSectionEntry : unjoinedSections.entrySet()) {
            String unjoinedSectionName = (String)unjoinedSectionEntry.getKey();
            Map unjoinedSectionOptions = (Map)unjoinedSectionEntry.getValue();
            LinkedHashMap<String, String> sectionOptions = new LinkedHashMap<String, String>();
            for (Map.Entry unjoinedOptionValueEntry : unjoinedSectionOptions.entrySet()) {
                String optionValue;
                String unjoinedOptionName = (String)unjoinedOptionValueEntry.getKey();
                List unjoinedOptionValue = (List)unjoinedOptionValueEntry.getValue();
                if (unjoinedOptionValue.size() > 0) {
                    ListIterator iter = unjoinedOptionValue.listIterator(unjoinedOptionValue.size());
                    while (iter.hasPrevious() && StringUtil.strip((String)iter.previous()).isEmpty()) {
                        iter.remove();
                    }
                    StringBuilder optionValueBuilder = new StringBuilder();
                    String prefix = "";
                    for (String valueLine : unjoinedOptionValue) {
                        optionValueBuilder.append(prefix);
                        prefix = "\n";
                        optionValueBuilder.append(valueLine);
                    }
                    optionValue = optionValueBuilder.toString();
                } else {
                    optionValue = null;
                }
                sectionOptions.put(unjoinedOptionName, optionValue);
            }
            this.sections.put(unjoinedSectionName, sectionOptions);
        }
        if (this.allowInterpolation) {
            this.interpolate();
            if (this.parsingErrors.size() > 0) {
                throw new IniParserException(this.parsingErrors);
            }
        }
        return this;
    }

    public Ini read(Path iniPath) throws IOException, IniParserException {
        this.read(iniPath, StandardCharsets.UTF_8);
        return this;
    }

    public Ini read(Path iniPath, Charset charset) throws IOException, IniParserException {
        try (BufferedReader reader = Files.newBufferedReader(iniPath, charset);){
            this.read(reader);
        }
        return this;
    }

    public Ini setAllowDuplicates(boolean allowDuplicates) {
        this.allowDuplicates = allowDuplicates;
        return this;
    }

    public Ini setAllowInterpolation(boolean allowInterpolation) {
        this.allowInterpolation = allowInterpolation;
        return this;
    }

    public Ini setAllowNoValue(boolean allowNoValue) {
        this.allowNoValue = allowNoValue;
        this.compileOptionPattern();
        return this;
    }

    public Ini setCommentPrefixes(List<String> commentPrefixes) {
        this.commentPrefixes = commentPrefixes;
        return this;
    }

    public Ini setDelimiters(List<String> delimiters) {
        this.delimiters = delimiters;
        this.compileOptionPattern();
        return this;
    }

    public Ini setEmptyLinesInValues(boolean emptyLinesInValues) {
        this.emptyLinesInValues = emptyLinesInValues;
        return this;
    }

    public Ini setInlineCommentPrefixes(List<String> inlineCommentPrefixes) {
        this.inlineCommentPrefixes = inlineCommentPrefixes;
        return this;
    }

    public Ini setSpaceAroundDelimiters(boolean spaceAroundDelimiters) {
        this.spaceAroundDelimiters = spaceAroundDelimiters;
        return this;
    }

    public Ini write(BufferedWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.spaceAroundDelimiters) {
            sb.append(" ");
        }
        sb.append(this.delimiters.get(0));
        if (this.spaceAroundDelimiters) {
            sb.append(" ");
        }
        String delimiter = sb.toString();
        for (Map.Entry<String, Map<String, String>> sectionEntry : this.sections.entrySet()) {
            String sectionName = sectionEntry.getKey();
            Map<String, String> sectionOptions = sectionEntry.getValue();
            writer.append("[");
            writer.append(sectionName);
            writer.append("]");
            writer.newLine();
            for (Map.Entry<String, String> optionEntry : sectionOptions.entrySet()) {
                String rawKey;
                String option = optionEntry.getKey();
                String value = optionEntry.getValue();
                if (this.allowInterpolation && this.rawValues.containsKey(rawKey = sectionName + ":" + option.toLowerCase())) {
                    value = this.rawValues.get(rawKey);
                }
                writer.append(option);
                if (value != null || !this.allowNoValue) {
                    writer.append(delimiter);
                    if (value != null) {
                        writer.append(value.replace("\n", System.lineSeparator() + "\t"));
                    } else {
                        writer.append(value);
                    }
                }
                writer.newLine();
            }
            writer.newLine();
        }
        return this;
    }

    public Ini write(Path iniPath) throws IOException {
        this.write(iniPath, StandardCharsets.UTF_8);
        return this;
    }

    public Ini write(Path iniPath, Charset charset) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(iniPath, charset, new OpenOption[0]);){
            this.write(writer);
        }
        return this;
    }
}

