/*
 * Decompiled with CFR 0.152.
 */
package ca.szc.configparser.exceptions;

import ca.szc.configparser.exceptions.ParsingError;

public class InterpolationDepthError
extends ParsingError {
    private String section;
    private String option;
    private String value;

    public InterpolationDepthError(int lineNo, String option, String section, String value) {
        super(lineNo);
        this.option = option;
        this.section = section;
        this.value = value;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterpolationDepthError other = (InterpolationDepthError)obj;
        return (this.section == null ? other.section == null : this.section.equals(other.section)) && (this.option == null ? other.option == null : this.option.equals(other.option)) && (this.value == null ? other.value == null : this.value.equals(other.value));
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Interpolation depth exceeded processing '");
        sb.append(this.getValue());
        sb.append("' for option '");
        sb.append(this.getOptionName());
        sb.append("' in section '");
        sb.append(this.getSectionName());
        sb.append("'");
        return sb.toString();
    }

    public String getOptionName() {
        return this.option;
    }

    public String getSectionName() {
        return this.section;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.option == null ? 0 : this.option.hashCode());
        result = 31 * result + (this.section == null ? 0 : this.section.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }
}

