/*
 * Decompiled with CFR 0.152.
 */
package ca.szc.configparser.exceptions;

import ca.szc.configparser.exceptions.ParsingError;

public class InterpolationMissingOptionError
extends ParsingError {
    private String option;
    private String section;
    private String value;
    private String missingOption;

    public InterpolationMissingOptionError(int lineNo, String option, String section, String value, String missingOption) {
        super(lineNo);
        this.option = option;
        this.section = section;
        this.value = value;
        this.missingOption = missingOption;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterpolationMissingOptionError other = (InterpolationMissingOptionError)obj;
        return (this.section == null ? other.section == null : this.section.equals(other.section)) && (this.option == null ? other.option == null : this.option.equals(other.option)) && (this.value == null ? other.value == null : this.value.equals(other.value)) && (this.missingOption == null ? other.missingOption == null : this.missingOption.equals(other.missingOption));
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Interpolation error in section '");
        sb.append(this.getSectionName());
        sb.append("', option '");
        sb.append(this.getOptionName());
        sb.append("': '");
        sb.append(this.getValue());
        sb.append("' is missing option '");
        sb.append(this.getMissingOption());
        sb.append("'");
        return sb.toString();
    }

    public String getOptionName() {
        return this.option;
    }

    public String getSectionName() {
        return this.section;
    }

    public String getValue() {
        return this.value;
    }

    public String getMissingOption() {
        return this.missingOption;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.option == null ? 0 : this.option.hashCode());
        result = 31 * result + (this.section == null ? 0 : this.section.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.missingOption == null ? 0 : this.missingOption.hashCode());
        return result;
    }
}

