/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.job;

import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.batch.job.model.PartitionedUrl;
import ca.uhn.fhir.jpa.batch.job.model.RequestListJson;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.ResourceSearch;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.JobParametersValidator;

public class MultiUrlJobParameterValidator
implements JobParametersValidator {
    public static String JOB_PARAM_OPERATION_NAME = "operation-name";
    private final MatchUrlService myMatchUrlService;
    private final DaoRegistry myDaoRegistry;

    public MultiUrlJobParameterValidator(MatchUrlService theMatchUrlService, DaoRegistry theDaoRegistry) {
        this.myMatchUrlService = theMatchUrlService;
        this.myDaoRegistry = theDaoRegistry;
    }

    public void validate(JobParameters theJobParameters) throws JobParametersInvalidException {
        if (theJobParameters == null) {
            throw new JobParametersInvalidException("This job requires Parameters: [urlList]");
        }
        RequestListJson requestListJson = RequestListJson.fromJson(theJobParameters.getString("url-list"));
        for (PartitionedUrl partitionedUrl : requestListJson.getPartitionedUrls()) {
            String url = partitionedUrl.getUrl();
            try {
                ResourceSearch resourceSearch = this.myMatchUrlService.getResourceSearch(url, partitionedUrl.getRequestPartitionId());
                String resourceName = resourceSearch.getResourceName();
                if (this.myDaoRegistry.isResourceTypeSupported(resourceName)) continue;
                throw new JobParametersInvalidException("The resource type " + resourceName + " is not supported on this server.");
            }
            catch (UnsupportedOperationException e) {
                throw new JobParametersInvalidException("Failed to parse " + theJobParameters.getString(JOB_PARAM_OPERATION_NAME) + " " + "url-list" + " item " + url + ": " + e.getMessage());
            }
        }
    }
}

