/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.job;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.batch.job.model.PartitionedUrl;
import ca.uhn.fhir.jpa.batch.job.model.RequestListJson;
import ca.uhn.fhir.jpa.partition.IRequestPartitionHelperSvc;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.ResourceSearch;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class PartitionedUrlValidator {
    @Autowired
    MatchUrlService myMatchUrlService;
    @Autowired
    IRequestPartitionHelperSvc myRequestPartitionHelperSvc;
    @Autowired
    FhirContext myFhirContext;

    public RequestListJson buildRequestListJson(RequestDetails theRequest, List<String> theUrlsToProcess) {
        ArrayList<PartitionedUrl> partitionedUrls = new ArrayList<PartitionedUrl>();
        for (String url : theUrlsToProcess) {
            ResourceSearch resourceSearch = this.myMatchUrlService.getResourceSearch(url);
            RequestPartitionId requestPartitionId = this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForSearchType(theRequest, resourceSearch.getResourceName(), resourceSearch.getSearchParameterMap(), null);
            partitionedUrls.add(new PartitionedUrl(url, requestPartitionId));
        }
        RequestListJson retval = new RequestListJson();
        retval.setPartitionedUrls(partitionedUrls);
        return retval;
    }

    public RequestPartitionId requestPartitionIdFromRequest(RequestDetails theRequest) {
        Set allResourceNames = this.myFhirContext.getResourceTypes();
        SearchParameterMap map = SearchParameterMap.newSynchronous();
        for (String resourceName : allResourceNames) {
            this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForSearchType(theRequest, resourceName, map, null);
        }
        return this.myRequestPartitionHelperSvc.determineReadPartitionForRequestForSearchType(theRequest, "Patient", map, null);
    }
}

