/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.job.model;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.batch.job.model.PartitionedUrl;
import ca.uhn.fhir.model.api.IModelJson;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.JsonUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;

public class RequestListJson
implements IModelJson {
    static final ObjectMapper ourObjectMapper = new ObjectMapper();
    @JsonProperty(value="partitionedUrls")
    private List<PartitionedUrl> myPartitionedUrls;

    public static RequestListJson fromUrlStringsAndRequestPartitionIds(List<String> theUrls, List<RequestPartitionId> theRequestPartitionIds) {
        assert (theUrls.size() == theRequestPartitionIds.size());
        RequestListJson retval = new RequestListJson();
        ArrayList<PartitionedUrl> partitionedUrls = new ArrayList<PartitionedUrl>();
        for (int i = 0; i < theUrls.size(); ++i) {
            partitionedUrls.add(new PartitionedUrl(theUrls.get(i), theRequestPartitionIds.get(i)));
        }
        retval.setPartitionedUrls(partitionedUrls);
        return retval;
    }

    public static RequestListJson fromJson(String theJson) {
        try {
            return (RequestListJson)ourObjectMapper.readValue(theJson, RequestListJson.class);
        }
        catch (JsonProcessingException e) {
            throw new InternalErrorException("Failed to decode " + RequestListJson.class);
        }
    }

    public String toJson() {
        return JsonUtil.serializeOrInvalidRequest((IModelJson)this);
    }

    public String toString() {
        return "RequestListJson{myPartitionedUrls=" + this.myPartitionedUrls + '}';
    }

    public List<PartitionedUrl> getPartitionedUrls() {
        return this.myPartitionedUrls;
    }

    public void setPartitionedUrls(List<PartitionedUrl> thePartitionedUrls) {
        this.myPartitionedUrls = thePartitionedUrls;
    }
}

