/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.listener;

import java.util.List;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterRead;
import org.springframework.batch.core.annotation.BeforeStep;

public class PidReaderCounterListener {
    public static final String RESOURCE_TOTAL_PROCESSED = "resource.total.processed";
    private StepExecution myStepExecution;
    private Long myTotalPidsProcessed = 0L;

    @BeforeStep
    public void setStepExecution(StepExecution stepExecution) {
        this.myStepExecution = stepExecution;
    }

    @AfterRead
    public void afterRead(List<Long> thePids) {
        this.myTotalPidsProcessed = this.myTotalPidsProcessed + (long)thePids.size();
        this.myStepExecution.getExecutionContext().putLong(RESOURCE_TOTAL_PROCESSED, this.myTotalPidsProcessed.longValue());
    }
}

