/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.processor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.dao.mdm.MdmExpansionCacheSvc;
import ca.uhn.fhir.util.ExtensionUtil;
import ca.uhn.fhir.util.SearchParameterUtil;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class GoldenResourceAnnotatingProcessor
implements ItemProcessor<List<IBaseResource>, List<IBaseResource>> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    @Value(value="#{stepExecutionContext['resourceType']}")
    private String myResourceType;
    @Autowired
    private FhirContext myContext;
    @Autowired
    private MdmExpansionCacheSvc myMdmExpansionCacheSvc;
    @Value(value="#{jobParameters['expandMdm'] ?: false}")
    private boolean myMdmEnabled;
    private RuntimeSearchParam myRuntimeSearchParam;
    private String myPatientFhirPath;
    private IFhirPath myFhirPath;

    private void populateRuntimeSearchParam() {
        Optional oPatientSearchParam = SearchParameterUtil.getOnlyPatientSearchParamForResourceType((FhirContext)this.myContext, (String)this.myResourceType);
        if (!oPatientSearchParam.isPresent()) {
            String errorMessage = String.format("[%s] has  no search parameters that are for patients, so it is invalid for Group Bulk Export!", this.myResourceType);
            throw new IllegalArgumentException(errorMessage);
        }
        this.myRuntimeSearchParam = (RuntimeSearchParam)oPatientSearchParam.get();
    }

    public List<IBaseResource> process(List<IBaseResource> theIBaseResources) throws Exception {
        if (this.myMdmEnabled) {
            if (this.myRuntimeSearchParam == null) {
                this.populateRuntimeSearchParam();
            }
            if (this.myPatientFhirPath == null) {
                this.populatePatientFhirPath();
            }
            theIBaseResources.forEach(this::annotateClinicalResourceWithRelatedGoldenResourcePatient);
        }
        return theIBaseResources;
    }

    private void annotateClinicalResourceWithRelatedGoldenResourcePatient(IBaseResource iBaseResource) {
        Optional<String> patientReference = this.getPatientReference(iBaseResource);
        if (patientReference.isPresent()) {
            this.addGoldenResourceExtension(iBaseResource, patientReference.get());
        } else {
            ourLog.error("Failed to find the patient reference information for resource {}. This is a bug, as all resources which can be exported via Group Bulk Export must reference a patient.", (Object)iBaseResource);
        }
    }

    private Optional<String> getPatientReference(IBaseResource iBaseResource) {
        if (this.myResourceType.equalsIgnoreCase("Patient")) {
            return Optional.of(iBaseResource.getIdElement().getIdPart());
        }
        Optional optionalReference = this.getFhirParser().evaluateFirst((IBase)iBaseResource, this.myPatientFhirPath, IBaseReference.class);
        return optionalReference.map(theIBaseReference -> theIBaseReference.getReferenceElement().getIdPart());
    }

    private void addGoldenResourceExtension(IBaseResource iBaseResource, String sourceResourceId) {
        String goldenResourceId = this.myMdmExpansionCacheSvc.getGoldenResourceId(sourceResourceId);
        IBaseExtension extension = ExtensionUtil.getOrCreateExtension((IBase)iBaseResource, (String)"https://hapifhir.org/associated-patient-golden-resource/");
        if (!StringUtils.isBlank((CharSequence)goldenResourceId)) {
            ExtensionUtil.setExtension((FhirContext)this.myContext, (IBaseExtension)extension, (String)"reference", (Object)this.prefixPatient(goldenResourceId));
        }
    }

    private String prefixPatient(String theResourceId) {
        return "Patient/" + theResourceId;
    }

    private IFhirPath getFhirParser() {
        if (this.myFhirPath == null) {
            this.myFhirPath = this.myContext.newFhirPath();
        }
        return this.myFhirPath;
    }

    private String populatePatientFhirPath() {
        if (this.myPatientFhirPath == null) {
            this.myPatientFhirPath = this.myRuntimeSearchParam.getPath();
            if (this.myPatientFhirPath.contains(".where")) {
                this.myPatientFhirPath = this.myPatientFhirPath.substring(0, this.myPatientFhirPath.indexOf(".where"));
            }
        }
        return this.myPatientFhirPath;
    }
}

