/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.processor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IDao;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.batch.log.Logs;
import ca.uhn.fhir.jpa.dao.ISearchBuilder;
import ca.uhn.fhir.jpa.dao.SearchBuilderFactory;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PidToIBaseResourceProcessor
implements ItemProcessor<List<ResourcePersistentId>, List<IBaseResource>> {
    private static final Logger ourLog = Logs.getBatchTroubleshootingLog();
    @Autowired
    private SearchBuilderFactory mySearchBuilderFactory;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Value(value="#{stepExecutionContext['resourceType']}")
    private String myResourceType;
    @Autowired
    private FhirContext myContext;

    public List<IBaseResource> process(List<ResourcePersistentId> theResourcePersistentId) {
        String collect = theResourcePersistentId.stream().map(pid -> pid.getId().toString()).collect(Collectors.joining(","));
        ourLog.trace("Processing PIDs: {}" + collect);
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(this.myResourceType);
        Class resourceTypeClass = this.myContext.getResourceDefinition(this.myResourceType).getImplementingClass();
        ISearchBuilder sb = this.mySearchBuilderFactory.newSearchBuilder((IDao)dao, this.myResourceType, resourceTypeClass);
        ArrayList<IBaseResource> outgoing = new ArrayList<IBaseResource>();
        sb.loadResourcesByPid(theResourcePersistentId, Collections.emptyList(), outgoing, false, null);
        ourLog.trace("Loaded resources: {}", (Object)outgoing.stream().map(t -> t.getIdElement().getValue()).collect(Collectors.joining(", ")));
        return outgoing;
    }
}

