/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.reader;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDateThresholdUpdater {
    private static final Logger ourLog = LoggerFactory.getLogger(BatchDateThresholdUpdater.class);
    private Function<Long, Date> myDateFromPid;

    public BatchDateThresholdUpdater() {
    }

    public BatchDateThresholdUpdater(Function<Long, Date> theDateFromPid) {
        this.myDateFromPid = theDateFromPid;
    }

    public Date updateThresholdAndCache(Date thePrevThreshold, Set<Long> theAlreadyProcessedPidsWithThresholdDate, List<Long> theProcessedPidsOrderedByDate) {
        Long pid;
        Date newDate;
        if (theProcessedPidsOrderedByDate.isEmpty()) {
            return thePrevThreshold;
        }
        Long pidOfLatestResourceInBatch = theProcessedPidsOrderedByDate.get(theProcessedPidsOrderedByDate.size() - 1);
        Date latestUpdatedDate = this.myDateFromPid.apply(pidOfLatestResourceInBatch);
        if (thePrevThreshold != latestUpdatedDate) {
            theAlreadyProcessedPidsWithThresholdDate.clear();
        }
        theAlreadyProcessedPidsWithThresholdDate.add(pidOfLatestResourceInBatch);
        Date newThreshold = latestUpdatedDate;
        if (theProcessedPidsOrderedByDate.size() <= 1) {
            return newThreshold;
        }
        for (int index = theProcessedPidsOrderedByDate.size() - 2; index >= 0 && latestUpdatedDate.equals(newDate = this.myDateFromPid.apply(pid = theProcessedPidsOrderedByDate.get(index))); --index) {
            theAlreadyProcessedPidsWithThresholdDate.add(pid);
        }
        return newThreshold;
    }

    public BatchDateThresholdUpdater setDateFromPid(Function<Long, Date> theDateFromPid) {
        this.myDateFromPid = theDateFromPid;
        return this;
    }
}

