/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.reader;

import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.config.DaoConfig;
import ca.uhn.fhir.jpa.batch.reader.BatchDateThresholdUpdater;
import ca.uhn.fhir.jpa.dao.data.IResourceTableDao;
import ca.uhn.fhir.jpa.model.entity.ResourceTable;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;

public class CronologicalBatchAllResourcePidReader
implements ItemReader<List<Long>>,
ItemStream {
    public static final String JOB_PARAM_BATCH_SIZE = "batch-size";
    public static final String JOB_PARAM_START_TIME = "start-time";
    public static final String JOB_PARAM_REQUEST_PARTITION = "request-partition";
    public static final String CURRENT_THRESHOLD_LOW = "current.threshold-low";
    private static final Logger ourLog = LoggerFactory.getLogger(CronologicalBatchAllResourcePidReader.class);
    private static final Date BEGINNING_OF_TIME = new Date(0L);
    @Autowired
    private IResourceTableDao myResourceTableDao;
    @Autowired
    private DaoConfig myDaoConfig;
    private Integer myBatchSize;
    private Date myThresholdLow = BEGINNING_OF_TIME;
    private final BatchDateThresholdUpdater myBatchDateThresholdUpdater = new BatchDateThresholdUpdater(this::dateFromPid);
    private final Set<Long> myAlreadyProcessedPidsWithLowDate = new HashSet<Long>();
    private Date myStartTime;
    private RequestPartitionId myRequestPartitionId;

    @Autowired
    public void setBatchSize(@Value(value="#{jobParameters['batch-size']}") Integer theBatchSize) {
        this.myBatchSize = theBatchSize;
    }

    @Autowired
    public void setStartTime(@Value(value="#{jobParameters['start-time']}") Date theStartTime) {
        this.myStartTime = theStartTime;
    }

    public static JobParameters buildJobParameters(Integer theBatchSize, RequestPartitionId theRequestPartitionId) {
        HashMap<String, JobParameter> map = new HashMap<String, JobParameter>();
        map.put(JOB_PARAM_REQUEST_PARTITION, new JobParameter(theRequestPartitionId.toJson()));
        map.put(JOB_PARAM_START_TIME, new JobParameter(DateUtils.addMinutes((Date)new Date(), (int)1)));
        if (theBatchSize != null) {
            map.put(JOB_PARAM_BATCH_SIZE, new JobParameter(Long.valueOf(theBatchSize.longValue())));
        }
        JobParameters parameters = new JobParameters(map);
        return parameters;
    }

    public List<Long> read() throws Exception {
        List<Long> nextBatch = this.getNextBatch();
        return nextBatch.isEmpty() ? null : nextBatch;
    }

    private Date dateFromPid(Long thePid) {
        ResourceTable entity = (ResourceTable)this.myResourceTableDao.findById(thePid).orElseThrow(IllegalStateException::new);
        return entity.getUpdatedDate();
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (this.myBatchSize == null) {
            this.myBatchSize = this.myDaoConfig.getExpungeBatchSize();
        }
        if (executionContext.containsKey(CURRENT_THRESHOLD_LOW)) {
            this.myThresholdLow = new Date(executionContext.getLong(CURRENT_THRESHOLD_LOW));
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        executionContext.putLong(CURRENT_THRESHOLD_LOW, this.myThresholdLow.getTime());
    }

    public void close() throws ItemStreamException {
    }

    private List<Long> getNextBatch() {
        Slice<Long> slice;
        PageRequest page = PageRequest.of((int)0, (int)this.myBatchSize);
        ArrayList<Long> retval = new ArrayList<Long>();
        do {
            slice = this.myRequestPartitionId == null || this.myRequestPartitionId.isAllPartitions() ? this.myResourceTableDao.findIdsOfResourcesWithinUpdatedRangeOrderedFromOldest((Pageable)page, this.myThresholdLow, this.myStartTime) : this.myResourceTableDao.findIdsOfPartitionedResourcesWithinUpdatedRangeOrderedFromOldest((Pageable)page, this.myThresholdLow, this.myStartTime, this.myRequestPartitionId.getFirstPartitionIdOrNull());
            retval.addAll(slice.getContent());
            retval.removeAll(this.myAlreadyProcessedPidsWithLowDate);
            page = page.next();
        } while (retval.size() < this.myBatchSize && slice.hasNext());
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("Results: {}", retval);
        }
        this.myThresholdLow = this.myBatchDateThresholdUpdater.updateThresholdAndCache(this.myThresholdLow, this.myAlreadyProcessedPidsWithLowDate, retval);
        return retval;
    }

    @Autowired
    public void setRequestPartitionId(@Value(value="#{jobParameters['request-partition']}") String theRequestPartitionIdJson) throws JsonProcessingException {
        if (theRequestPartitionIdJson == null) {
            return;
        }
        this.myRequestPartitionId = RequestPartitionId.fromJson((String)theRequestPartitionIdJson);
    }
}

