/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.reader;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.interceptor.model.RequestPartitionId;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.batch.job.MultiUrlJobParameterValidator;
import ca.uhn.fhir.jpa.batch.job.model.PartitionedUrl;
import ca.uhn.fhir.jpa.batch.job.model.RequestListJson;
import ca.uhn.fhir.jpa.batch.reader.BatchDateThresholdUpdater;
import ca.uhn.fhir.jpa.batch.reader.BatchResourceSearcher;
import ca.uhn.fhir.jpa.dao.IResultIterator;
import ca.uhn.fhir.jpa.searchparam.MatchUrlService;
import ca.uhn.fhir.jpa.searchparam.ResourceSearch;
import ca.uhn.fhir.jpa.searchparam.SearchParameterMap;
import ca.uhn.fhir.rest.api.SortOrderEnum;
import ca.uhn.fhir.rest.api.SortSpec;
import ca.uhn.fhir.rest.api.server.storage.ResourcePersistentId;
import ca.uhn.fhir.rest.param.DateRangeParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.time.DateUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ReverseCronologicalBatchResourcePidReader
implements ItemReader<List<Long>>,
ItemStream {
    private static final Logger ourLog = LoggerFactory.getLogger(ReverseCronologicalBatchResourcePidReader.class);
    public static final String JOB_PARAM_REQUEST_LIST = "url-list";
    public static final String JOB_PARAM_BATCH_SIZE = "batch-size";
    public static final String JOB_PARAM_START_TIME = "start-time";
    public static final String CURRENT_URL_INDEX = "current.url-index";
    public static final String CURRENT_THRESHOLD_HIGH = "current.threshold-high";
    @Autowired
    private FhirContext myFhirContext;
    @Autowired
    private MatchUrlService myMatchUrlService;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired
    private BatchResourceSearcher myBatchResourceSearcher;
    private final BatchDateThresholdUpdater myBatchDateThresholdUpdater = new BatchDateThresholdUpdater();
    private List<PartitionedUrl> myPartitionedUrls;
    private Integer myBatchSize;
    private final Map<Integer, Date> myThresholdHighByUrlIndex = new HashMap<Integer, Date>();
    private final Map<Integer, Set<Long>> myAlreadyProcessedPidsWithHighDate = new HashMap<Integer, Set<Long>>();
    private int myUrlIndex = 0;
    private Date myStartTime;

    @Autowired
    public void setRequestListJson(@Value(value="#{jobParameters['url-list']}") String theRequestListJson) {
        RequestListJson requestListJson = RequestListJson.fromJson(theRequestListJson);
        this.myPartitionedUrls = requestListJson.getPartitionedUrls();
    }

    @Autowired
    public void setBatchSize(@Value(value="#{jobParameters['batch-size']}") Integer theBatchSize) {
        this.myBatchSize = theBatchSize;
    }

    @Autowired
    public void setStartTime(@Value(value="#{jobParameters['start-time']}") Date theStartTime) {
        this.myStartTime = theStartTime;
    }

    public List<Long> read() throws Exception {
        while (this.myUrlIndex < this.myPartitionedUrls.size()) {
            List<Long> nextBatch = this.getNextBatch();
            if (nextBatch.isEmpty()) {
                ++this.myUrlIndex;
                continue;
            }
            return nextBatch;
        }
        return null;
    }

    private List<Long> getNextBatch() {
        RequestPartitionId requestPartitionId = this.myPartitionedUrls.get(this.myUrlIndex).getRequestPartitionId();
        ResourceSearch resourceSearch = this.myMatchUrlService.getResourceSearch(this.myPartitionedUrls.get(this.myUrlIndex).getUrl(), requestPartitionId);
        this.addDateCountAndSortToSearch(resourceSearch);
        IResultIterator resultIter = this.myBatchResourceSearcher.performSearch(resourceSearch, this.myBatchSize);
        LinkedHashSet newPids = new LinkedHashSet();
        Set alreadySeenPids = this.myAlreadyProcessedPidsWithHighDate.computeIfAbsent(this.myUrlIndex, i -> new HashSet());
        do {
            List pids = resultIter.getNextResultBatch(this.myBatchSize.intValue()).stream().map(ResourcePersistentId::getIdAsLong).collect(Collectors.toList());
            newPids.addAll(pids);
            newPids.removeAll(alreadySeenPids);
        } while (newPids.size() < this.myBatchSize && resultIter.hasNext());
        if (ourLog.isDebugEnabled()) {
            ourLog.debug("Search for {}{} returned {} results", new Object[]{resourceSearch.getResourceName(), resourceSearch.getSearchParameterMap().toNormalizedQueryString(this.myFhirContext), newPids.size()});
            ourLog.debug("Results: {}", newPids);
        }
        this.setDateFromPidFunction(resourceSearch);
        ArrayList<Long> retval = new ArrayList<Long>(newPids);
        Date newThreshold = this.myBatchDateThresholdUpdater.updateThresholdAndCache(this.myThresholdHighByUrlIndex.get(this.myUrlIndex), this.myAlreadyProcessedPidsWithHighDate.get(this.myUrlIndex), retval);
        this.myThresholdHighByUrlIndex.put(this.myUrlIndex, newThreshold);
        return retval;
    }

    private void setDateFromPidFunction(ResourceSearch resourceSearch) {
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceSearch.getResourceName());
        this.myBatchDateThresholdUpdater.setDateFromPid(pid -> {
            IBaseResource oldestResource = dao.readByPid(new ResourcePersistentId(pid));
            return oldestResource.getMeta().getLastUpdated();
        });
    }

    private void addDateCountAndSortToSearch(ResourceSearch resourceSearch) {
        SearchParameterMap map = resourceSearch.getSearchParameterMap();
        map.setLastUpdated(new DateRangeParam().setUpperBoundInclusive(this.myThresholdHighByUrlIndex.get(this.myUrlIndex)));
        map.setLoadSynchronousUpTo(this.myBatchSize);
        map.setSort(new SortSpec("_lastUpdated", SortOrderEnum.DESC));
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        if (executionContext.containsKey(CURRENT_URL_INDEX)) {
            this.myUrlIndex = new Long(executionContext.getLong(CURRENT_URL_INDEX)).intValue();
        }
        for (int index = 0; index < this.myPartitionedUrls.size(); ++index) {
            String key = ReverseCronologicalBatchResourcePidReader.highKey(index);
            if (executionContext.containsKey(key)) {
                this.myThresholdHighByUrlIndex.put(index, new Date(executionContext.getLong(key)));
                continue;
            }
            this.myThresholdHighByUrlIndex.put(index, this.myStartTime);
        }
    }

    private static String highKey(int theIndex) {
        return "current.threshold-high." + theIndex;
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        executionContext.putLong(CURRENT_URL_INDEX, (long)this.myUrlIndex);
        for (int index = 0; index < this.myPartitionedUrls.size(); ++index) {
            Date date = this.myThresholdHighByUrlIndex.get(index);
            if (date == null) continue;
            executionContext.putLong(ReverseCronologicalBatchResourcePidReader.highKey(index), date.getTime());
        }
    }

    public void close() throws ItemStreamException {
    }

    @Nonnull
    public static JobParameters buildJobParameters(String theOperationName, Integer theBatchSize, RequestListJson theRequestListJson) {
        HashMap<String, JobParameter> map = new HashMap<String, JobParameter>();
        map.put(MultiUrlJobParameterValidator.JOB_PARAM_OPERATION_NAME, new JobParameter(theOperationName));
        map.put(JOB_PARAM_REQUEST_LIST, new JobParameter(theRequestListJson.toJson()));
        map.put(JOB_PARAM_START_TIME, new JobParameter(DateUtils.addMinutes((Date)new Date(), (int)1)));
        if (theBatchSize != null) {
            map.put(JOB_PARAM_BATCH_SIZE, new JobParameter(Long.valueOf(theBatchSize.longValue())));
        }
        JobParameters parameters = new JobParameters(map);
        return parameters;
    }
}

