/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.batch.writer;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.item.ItemWriter;

public class SqlExecutorWriter
implements ItemWriter<List<String>> {
    private static final Logger ourLog = LoggerFactory.getLogger(SqlExecutorWriter.class);
    public static final String ENTITY_TOTAL_UPDATED_OR_DELETED = "entity.total.updated-or-deleted";
    @PersistenceContext(type=PersistenceContextType.TRANSACTION)
    private EntityManager myEntityManager;
    private Long totalUpdated = 0L;
    private StepExecution myStepExecution;

    @BeforeStep
    public void setStepExecution(StepExecution stepExecution) {
        this.myStepExecution = stepExecution;
    }

    public void write(List<? extends List<String>> theSqlLists) throws Exception {
        for (List<String> list : theSqlLists) {
            ourLog.info("Executing {} sql commands", (Object)list.size());
            for (String sql : list) {
                ourLog.trace("Executing sql " + sql);
                this.totalUpdated = this.totalUpdated + (long)this.myEntityManager.createNativeQuery(sql).executeUpdate();
                this.myStepExecution.getExecutionContext().putLong(ENTITY_TOTAL_UPDATED_OR_DELETED, this.totalUpdated.longValue());
            }
        }
        ourLog.debug("{} records updated", (Object)this.totalUpdated);
    }
}

