/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binstore;

import ca.uhn.fhir.jpa.binstore.IBinaryStorageSvc;
import ca.uhn.fhir.rest.server.exceptions.PayloadTooLargeException;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.security.SecureRandom;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IIdType;

abstract class BaseBinaryStorageSvcImpl
implements IBinaryStorageSvc {
    private final SecureRandom myRandom;
    private final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private final int ID_LENGTH = 100;
    private int myMaximumBinarySize = Integer.MAX_VALUE;
    private int myMinimumBinarySize;

    BaseBinaryStorageSvcImpl() {
        this.myRandom = new SecureRandom();
    }

    @Override
    public int getMaximumBinarySize() {
        return this.myMaximumBinarySize;
    }

    @Override
    public void setMaximumBinarySize(int theMaximumBinarySize) {
        Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)theMaximumBinarySize);
        this.myMaximumBinarySize = theMaximumBinarySize;
    }

    @Override
    public int getMinimumBinarySize() {
        return this.myMinimumBinarySize;
    }

    @Override
    public void setMinimumBinarySize(int theMinimumBinarySize) {
        this.myMinimumBinarySize = theMinimumBinarySize;
    }

    @Override
    public String newBlobId() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            int nextInt = Math.abs(this.myRandom.nextInt());
            b.append("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".charAt(nextInt % "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".length()));
        }
        return b.toString();
    }

    @Override
    public boolean shouldStoreBlob(long theSize, IIdType theResourceId, String theContentType) {
        return theSize >= (long)this.getMinimumBinarySize();
    }

    @Nonnull
    HashingInputStream createHashingInputStream(InputStream theInputStream) {
        HashFunction hash = Hashing.sha256();
        return new HashingInputStream(hash, theInputStream);
    }

    @Nonnull
    CountingInputStream createCountingInputStream(InputStream theInputStream) {
        InputStream is = ByteStreams.limit((InputStream)theInputStream, (long)((long)this.getMaximumBinarySize() + 1L));
        return new CountingInputStream(is){

            public int getCount() {
                int retVal = super.getCount();
                if (retVal > BaseBinaryStorageSvcImpl.this.getMaximumBinarySize()) {
                    throw new PayloadTooLargeException("Binary size exceeds maximum: " + BaseBinaryStorageSvcImpl.this.getMaximumBinarySize());
                }
                return retVal;
            }
        };
    }

    String provideIdForNewBlob(String theBlobIdOrNull) {
        String id = theBlobIdOrNull;
        if (StringUtils.isBlank((CharSequence)theBlobIdOrNull)) {
            id = this.newBlobId();
        }
        return id;
    }
}

