/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.binstore;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jpa.api.dao.DaoRegistry;
import ca.uhn.fhir.jpa.api.dao.IFhirResourceDao;
import ca.uhn.fhir.jpa.api.model.DaoMethodOutcome;
import ca.uhn.fhir.jpa.binstore.IBinaryStorageSvc;
import ca.uhn.fhir.jpa.binstore.IBinaryTarget;
import ca.uhn.fhir.jpa.binstore.StoredDetails;
import ca.uhn.fhir.jpa.model.util.JpaConstants;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.annotation.Operation;
import ca.uhn.fhir.rest.annotation.OperationParam;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.servlet.ServletRequestDetails;
import ca.uhn.fhir.util.AttachmentUtil;
import ca.uhn.fhir.util.BinaryUtil;
import ca.uhn.fhir.util.DateUtils;
import ca.uhn.fhir.util.UrlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BinaryAccessProvider {
    private static final Logger ourLog = LoggerFactory.getLogger(BinaryAccessProvider.class);
    @Autowired
    private FhirContext myCtx;
    @Autowired
    private DaoRegistry myDaoRegistry;
    @Autowired(required=false)
    private IBinaryStorageSvc myBinaryStorageSvc;

    @Operation(name="$binary-access-read", global=true, manualResponse=true, idempotent=true)
    public void binaryAccessRead(@IdParam IIdType theResourceId, @OperationParam(name="path", min=1, max=1) IPrimitiveType<String> thePath, ServletRequestDetails theRequestDetails, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws IOException {
        String path = this.validateResourceTypeAndPath(theResourceId, thePath);
        IFhirResourceDao dao = this.getDaoForRequest(theResourceId);
        IBaseResource resource = dao.read(theResourceId, (RequestDetails)theRequestDetails, false);
        IBinaryTarget target = this.findAttachmentForRequest(resource, path, theRequestDetails);
        Optional<String> attachmentId = target.getAttachmentId();
        if (attachmentId.isPresent()) {
            String blobId = attachmentId.get();
            StoredDetails blobDetails = this.myBinaryStorageSvc.fetchBlobDetails(theResourceId, blobId);
            if (blobDetails == null) {
                String msg = this.myCtx.getLocalizer().getMessage(BinaryAccessProvider.class, "unknownBlobId", new Object[0]);
                throw new InvalidRequestException(msg);
            }
            theServletResponse.setStatus(200);
            theServletResponse.setContentType(blobDetails.getContentType());
            if (blobDetails.getBytes() <= Integer.MAX_VALUE) {
                theServletResponse.setContentLength((int)blobDetails.getBytes());
            }
            RestfulServer server = theRequestDetails.getServer();
            server.addHeadersToResponse(theServletResponse);
            theServletResponse.addHeader("Cache-Control", "private");
            theServletResponse.addHeader("ETag", '\"' + blobDetails.getHash() + '\"');
            theServletResponse.addHeader("Last-Modified", DateUtils.formatDate((Date)blobDetails.getPublished()));
            this.myBinaryStorageSvc.writeBlob(theResourceId, blobId, (OutputStream)theServletResponse.getOutputStream());
            theServletResponse.getOutputStream().close();
        } else {
            String contentType = target.getContentType();
            contentType = (String)StringUtils.defaultIfBlank((CharSequence)contentType, (CharSequence)"application/octet-stream");
            byte[] data = target.getData();
            if (data == null) {
                String msg = this.myCtx.getLocalizer().getMessage(BinaryAccessProvider.class, "noAttachmentDataPresent", new Object[]{UrlUtil.sanitizeUrlPart((IPrimitiveType)theResourceId), UrlUtil.sanitizeUrlPart(thePath)});
                throw new InvalidRequestException(msg);
            }
            theServletResponse.setStatus(200);
            theServletResponse.setContentType(contentType);
            theServletResponse.setContentLength(data.length);
            RestfulServer server = theRequestDetails.getServer();
            server.addHeadersToResponse(theServletResponse);
            theServletResponse.getOutputStream().write(data);
            theServletResponse.getOutputStream().close();
        }
    }

    @Operation(name="$binary-access-write", global=true, manualRequest=true, idempotent=false)
    public IBaseResource binaryAccessWrite(@IdParam IIdType theResourceId, @OperationParam(name="path", min=1, max=1) IPrimitiveType<String> thePath, ServletRequestDetails theRequestDetails, HttpServletRequest theServletRequest, HttpServletResponse theServletResponse) throws IOException {
        String path = this.validateResourceTypeAndPath(theResourceId, thePath);
        IFhirResourceDao dao = this.getDaoForRequest(theResourceId);
        IBaseResource resource = dao.read(theResourceId, (RequestDetails)theRequestDetails, false);
        IBinaryTarget target = this.findAttachmentForRequest(resource, path, theRequestDetails);
        String requestContentType = theServletRequest.getContentType();
        if (StringUtils.isBlank((CharSequence)requestContentType)) {
            throw new InvalidRequestException("No content-target supplied");
        }
        if (EncodingEnum.forContentTypeStrict((String)requestContentType) != null) {
            throw new InvalidRequestException("This operation is for binary content, got: " + requestContentType);
        }
        long size = theServletRequest.getContentLength();
        ourLog.trace("Request specified content length: {}", (Object)size);
        String blobId = null;
        if (size > 0L && this.myBinaryStorageSvc != null && this.myBinaryStorageSvc.shouldStoreBlob(size, theResourceId, requestContentType)) {
            StoredDetails storedDetails = this.myBinaryStorageSvc.storeBlob(theResourceId, null, requestContentType, theRequestDetails.getInputStream());
            size = storedDetails.getBytes();
            blobId = storedDetails.getBlobId();
            Validate.notBlank((CharSequence)blobId, (String)"BinaryStorageSvc returned a null blob ID", (Object[])new Object[0]);
        }
        if (blobId == null) {
            byte[] bytes = IOUtils.toByteArray((InputStream)theRequestDetails.getInputStream());
            size = bytes.length;
            target.setData(bytes);
        } else {
            this.replaceDataWithExtension(target, blobId);
        }
        target.setContentType(requestContentType);
        target.setSize(null);
        if (size <= Integer.MAX_VALUE) {
            target.setSize((int)size);
        }
        DaoMethodOutcome outcome = dao.update(resource, (RequestDetails)theRequestDetails);
        return outcome.getResource();
    }

    public void replaceDataWithExtension(IBinaryTarget theTarget, String theBlobId) {
        theTarget.getTarget().getExtension().removeIf(t -> "http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id".equals(t.getUrl()));
        theTarget.setData(null);
        IBaseExtension ext = theTarget.getTarget().addExtension();
        ext.setUrl("http://hapifhir.io/fhir/StructureDefinition/externalized-binary-id");
        ext.setUserData(JpaConstants.EXTENSION_EXT_SYSTEMDEFINED, (Object)Boolean.TRUE);
        IPrimitiveType blobIdString = (IPrimitiveType)this.myCtx.getElementDefinition("string").newInstance();
        blobIdString.setValueAsString(theBlobId);
        ext.setValue((IBaseDatatype)blobIdString);
    }

    @Nonnull
    private IBinaryTarget findAttachmentForRequest(IBaseResource theResource, String thePath, ServletRequestDetails theRequestDetails) {
        Optional type = this.myCtx.newFluentPath().evaluateFirst((IBase)theResource, thePath, IBase.class);
        String resType = this.myCtx.getResourceType(theResource);
        if (!type.isPresent()) {
            String msg = this.myCtx.getLocalizer().getMessageSanitized(BinaryAccessProvider.class, "unknownPath", new Object[]{resType, thePath});
            throw new InvalidRequestException(msg);
        }
        IBase element = (IBase)type.get();
        Optional<IBinaryTarget> binaryTarget = this.toBinaryTarget(element);
        if (!binaryTarget.isPresent()) {
            BaseRuntimeElementDefinition def2 = this.myCtx.getElementDefinition(element.getClass());
            String msg = this.myCtx.getLocalizer().getMessageSanitized(BinaryAccessProvider.class, "unknownType", new Object[]{resType, thePath, def2.getName()});
            throw new InvalidRequestException(msg);
        }
        return binaryTarget.get();
    }

    public Optional<IBinaryTarget> toBinaryTarget(IBase theElement) {
        IBinaryTarget binaryTarget = null;
        BaseRuntimeElementDefinition def = this.myCtx.getElementDefinition(theElement.getClass());
        if (def.getName().equals("Attachment")) {
            final ICompositeType attachment = (ICompositeType)theElement;
            binaryTarget = new IBinaryTarget(){

                @Override
                public void setSize(Integer theSize) {
                    AttachmentUtil.setSize((FhirContext)BinaryAccessProvider.this.myCtx, (ICompositeType)attachment, (Integer)theSize);
                }

                @Override
                public String getContentType() {
                    return AttachmentUtil.getOrCreateContentType((FhirContext)BinaryAccessProvider.this.myCtx, (ICompositeType)attachment).getValueAsString();
                }

                @Override
                public byte[] getData() {
                    IPrimitiveType dataDt = AttachmentUtil.getOrCreateData((FhirContext)BinaryAccessProvider.this.myCtx, (ICompositeType)attachment);
                    return (byte[])dataDt.getValue();
                }

                @Override
                public IBaseHasExtensions getTarget() {
                    return (IBaseHasExtensions)AttachmentUtil.getOrCreateData((FhirContext)BinaryAccessProvider.this.myCtx, (ICompositeType)attachment);
                }

                @Override
                public void setContentType(String theContentType) {
                    AttachmentUtil.setContentType((FhirContext)BinaryAccessProvider.this.myCtx, (ICompositeType)attachment, (String)theContentType);
                }

                @Override
                public void setData(byte[] theBytes) {
                    AttachmentUtil.setData((FhirContext)BinaryAccessProvider.this.myCtx, (ICompositeType)attachment, (byte[])theBytes);
                }
            };
        }
        if (def.getName().equals("Binary")) {
            final IBaseBinary binary = (IBaseBinary)theElement;
            binaryTarget = new IBinaryTarget(){

                @Override
                public void setSize(Integer theSize) {
                }

                @Override
                public String getContentType() {
                    return binary.getContentType();
                }

                @Override
                public byte[] getData() {
                    return binary.getContent();
                }

                @Override
                public IBaseHasExtensions getTarget() {
                    return (IBaseHasExtensions)BinaryUtil.getOrCreateData((FhirContext)BinaryAccessProvider.this.myCtx, (IBaseBinary)binary);
                }

                @Override
                public void setContentType(String theContentType) {
                    binary.setContentType(theContentType);
                }

                @Override
                public void setData(byte[] theBytes) {
                    binary.setContent(theBytes);
                }
            };
        }
        return Optional.ofNullable(binaryTarget);
    }

    private String validateResourceTypeAndPath(@IdParam IIdType theResourceId, @OperationParam(name="path", min=1, max=1) IPrimitiveType<String> thePath) {
        if (StringUtils.isBlank((CharSequence)theResourceId.getResourceType())) {
            throw new InvalidRequestException("No resource type specified");
        }
        if (StringUtils.isBlank((CharSequence)theResourceId.getIdPart())) {
            throw new InvalidRequestException("No ID specified");
        }
        if (thePath == null || StringUtils.isBlank((CharSequence)((CharSequence)thePath.getValue()))) {
            if ("Binary".equals(theResourceId.getResourceType())) {
                return "Binary";
            }
            throw new InvalidRequestException("No path specified");
        }
        return (String)thePath.getValue();
    }

    @Nonnull
    private IFhirResourceDao getDaoForRequest(@IdParam IIdType theResourceId) {
        String resourceType = theResourceId.getResourceType();
        IFhirResourceDao dao = this.myDaoRegistry.getResourceDao(resourceType);
        if (dao == null) {
            throw new InvalidRequestException("Unknown/unsupported resource type: " + UrlUtil.sanitizeUrlPart((CharSequence)resourceType));
        }
        return dao;
    }
}

